% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{git_config_files}
\alias{git_config_files}
\title{Locate the path to configuration files}
\usage{
git_config_files(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
a named list with one item per potential configuration
    file where \code{NA} means not found.
}
\description{
Potential configuration files:
\describe{
  \item{system}{
    Locate the path to the system configuration file. If
    '/etc/gitconfig' doesn't exist, it will look for
    '\%PROGRAMFILES\%'.
  }
  \item{xdg}{
    Locate the path to the global xdg compatible configuration
    file. The xdg compatible configuration file is usually located
    in '$HOME/.config/git/config'. This method will try to guess
    the full path to that file, if the file exists.
  }
  \item{global}{
    The user or global configuration file is usually located in
    '$HOME/.gitconfig'. This method will try to guess the full
    path to that file, if the file exists.
  }
  \item{local}{
    Locate the path to the repository specific configuration file,
    if the file exists.
  }
}
}
