% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdoor.R
\name{gd_api}
\alias{gd_api}
\title{General Glassdoor API function}
\usage{
gd_api(action = NULL, other = NULL, agent = gd_user_agent(),
  version = 1, q = NULL, format = "json", url = gd_url(),
  pid = gd_pid(), pat = gd_pat(), ip_address = NULL, query = NULL, ...)
}
\arguments{
\item{action}{The particular API call that you would like to make}

\item{other}{Each API action will require different parameters
For example, an \code{employerId} is passed in order to retrieve reviews.}

\item{agent}{The User-Agent (browser) of the end user to whom the API
results will be shown. Note that you can can obtain this from the
"User-Agent" HTTP request header from the end-user}

\item{version}{The API version. The current version is 1 except for
jobs, which is currently version 1.1}

\item{q}{Query parameter (not a list) for Glassdoor}

\item{format}{Either \code{xml} or \code{json} as you prefer}

\item{url}{Glassdoor RESTful API URL}

\item{pid}{Your partner id, as assigned by Glassdoor}

\item{pat}{Your partner key, as assigned by Glassdoor}

\item{ip_address}{The IP address of the end user to whom the API results will be shown}

\item{query}{Additional options to pass to the query other than those
specified here}

\item{...}{Additional options to send to \code{\link{GET}}}
}
\value{
A list of class \code{gd_api}
}
\description{
General Glassdoor API function
}
\examples{
if (have_gd_pid() && have_gd_pat()) {
res = gd_api(
action = "employers",
other = NULL,
  version = 1,
format = "json",
query = list(q = "pharmaceuticals"))

res = gd_api(
action = "employers",
other = NULL,
  version = 1,
format = "json",
q = "pharmaceuticals", config = list())
}
}
