% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glassdoor_employer.R
\name{gd_company}
\alias{gd_company}
\alias{gd_employer}
\alias{gd_company_df}
\alias{gd_employer_df}
\title{Glassdoor Company Search}
\usage{
gd_company(query = NULL, ..., location = NULL, city = NULL,
  state = NULL, country = NULL, page_number = NULL,
  page_size = NULL)

gd_employer(query = NULL, ..., location = NULL, city = NULL,
  state = NULL, country = NULL, page_number = NULL,
  page_size = NULL)

gd_company_df(...)

gd_employer_df(...)
}
\arguments{
\item{query}{Additional options to pass to the query other than those
specified here}

\item{...}{arguments to pass to \code{\link{gd_api}}}

\item{location}{Scope the search to a specific location by specifying it
here - city, state, or country.}

\item{city}{Scope the search to a specific city by specifying it here.}

\item{state}{Scope the search to a specific state by specifying it here.}

\item{country}{Scope the search to a specific country by specifying it here.}

\item{page_number}{Page number to retrieve. Default is 1.}

\item{page_size}{Page size, i.e. the number of jobs returned on
each page of results. Default is 20.}
}
\description{
Glassdoor Company Search
}
\examples{
if (have_gd_tokens()) {

res = gd_company_df("walmart")
head(res[, c("id", "name")])
res = gd_company_df("Target")
res = gd_company("Dropbox")
}

}
