% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getResidualCor.gllvm.R
\name{getResidualCor.gllvm}
\alias{getResidualCor.gllvm}
\title{Extract residual correlations from gllvm object}
\usage{
getResidualCor.gllvm(object)
}
\arguments{
\item{object}{an object of class 'gllvm'.}
}
\description{
Calculates the residual correlation from gllvm models.
}
\examples{
# Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
# Fit gllvm model
fit <- gllvm(y = y, family = "poisson")
# residual correlations:
cr <- getResidualCor.gllvm(fit)

\dontrun{
# Plot residual correlations:
install.packages("corrplot", "gclus")
library(corrplot)
library(gclus)
rbPal <- colorRampPalette(c('darkblue','white','darkred'))
breaks <- seq(min(cr$cor), max(cr$cor), length.out = 40)
Colors <- rbPal(100)[as.numeric(cut(cr$cor, breaks = breaks))]
corrplot(cr$cor[order.single(cr$cor), order.single(cr$cor)], diag = F,
  type = "lower", method = "square", tl.cex = 0.8, tl.srt = 45, tl.col = "red")
  }
}
\author{
Francis K.C. Hui, Jenni Niku, David I. Warton
}
