% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.gllvm.R
\name{anova.gllvm}
\alias{anova.gllvm}
\title{Analysis Of Deviance for gllvm}
\usage{
\method{anova}{gllvm}(object, ..., which = "multi", method = "holm")
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{...}{one or more objects of class 'gllvm'}

\item{which}{either "multi" or "uni". If "uni", performs anova for each species separately.}

\item{method}{method used to adjust p-values for multiple testing when \code{which="uni"}. One of "holm" (default), "hochberg", "hommel", "bonferonni", "BH", BY", "fdr", or "none". See \code{\link{p.adjust}} for more information.}
}
\description{
Computes an analysis of deviance table for two generalized linear latent variable model fits.
}
\details{
Computes likelihood-ratio test for two or more gllvm models.
Test results makes sense only for nested models.
Notice also that this test is not designed for testing models which have
degrees of freedom difference larger than 20. For such models
the P-value should be treated as very approximate.
}
\examples{
\donttest{
## Load a dataset from the mvabund package
data(antTraits)
y <- antTraits$abund
X <- antTraits$env
TR <- antTraits$traits
# Fit gllvm model
fit1 <- gllvm(y, X, TR, formula = ~ Bare.ground + Shrub.cover, family = poisson())
fit2 <- gllvm(y, X, TR, formula = ~ Bare.ground + Shrub.cover +
             (Bare.ground + Shrub.cover) : Webers.length, family = poisson())
# Test if the model with fourth corner interaction terms is significantly
# better using likelihood-ratio test:
anova(fit1, fit2)
}
}
\author{
Jenni Niku, Bert van der Veen
}
