% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{predict.ss_glmaag}
\alias{predict.ss_glmaag}
\title{Prediction via stability selection}
\usage{
\method{predict}{ss_glmaag}(object, x, type = "link", ...)
}
\arguments{
\item{object}{the ss_glmaag object}

\item{x}{the new dataset to be predicted, do training prediction if x is missing}

\item{type}{type of prediction (can be "link", or "reponse" ), ignored for Gaussian model. "link" is the linear predicted score, "response" is the predicted probability for logistic model and relative risk for Cox model}

\item{...}{\dots}
}
\value{
the predicted values
}
\description{
Predict using the model tuned by stability selection
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
mod <- ss_glmaag(y, x, L0, nsam = 3)
pp <- predict(mod)
}
