\name{restoreParams}
\alias{restoreParams}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Reparametrise bugs output}
\description{
  Undoes the parametrisation used in \code{\link{writeBugsModel}}, and gives the original names to random effect levels.
}
\usage{
restoreParams(bugsResult, ragged = NULL,extraX=NULL)
}

\arguments{
  \item{bugsResult}{Output from \code{\link[R2WinBUGS:bugs]{bugs}}, using a ragged array generated by \code{\link{winBugsRaggedArray}} and a model generated by \code{\link{writeBugsModel}}}
  \item{ragged}{The ragged array used to call \code{\link[R2WinBUGS:bugs]{bugs}}}
\item{extraX}{Possible extra covariates for spatial regions with no data but do have predicted spatial effects.}
}
\details{
 }
\value{
  A list where each element is a matrix or an array.  
  The first dimension is the number of realisations, 
  the second the number of chains, and for vector-valued parameters and 
  random effects, the third dimension is the length of the parameter.
  
  
If the model contains a spatial component, 
the result will have list entries the following:

\item{Reffect}{The random effect. In the case of spatial models this is the sum of the spatial and non-spatial random effects U+V.}, 
\item{ReffectSpatial}{The spatial random effect for each region, if any}
\item{FittedReffect}{The predicted values on the link scale, being the random effect plus intercept and effect of covariates.}
}
\references{}
\author{Patrick Brown \code{patrick.brown@utoronto.ca}}
\note{For spatial models, one fitted rate is computed 
for each region in the adjacency matrix, even though some of these regions may not have spatial or non-spatial random 
effects simulated in the bugs model.  If a spatial random effect is missing (as happens with islands), a zero is 
added.  If a non-spatial random effect is missing (as happens when a regions does not have data), a value is simulated
unconditionally from each iteration's intercept and standard deviation for that effect.  Note that this does not add 
on the effect of possible covariates for that region.  This can be added via the extraX argument.}
\seealso{\code{\link[R2WinBUGS:bugs]{bugs}}}
\examples{
                        
}
