% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.glmmTMB}
\alias{predict.glmmTMB}
\title{prediction}
\usage{
\method{predict}{glmmTMB}(object, newdata = NULL, se.fit = FALSE, re.form,
  allow.new.levels = FALSE, type = c("link", "response", "conditional",
  "zprob", "zlink"), zitype = NULL, na.action = na.pass, debug = FALSE,
  ...)
}
\arguments{
\item{object}{a \code{glmmTMB} object}

\item{newdata}{new data for prediction}

\item{se.fit}{return the standard errors of the predicted values?}

\item{re.form}{(not yet implemented) specify which random effects to condition on when predicting}

\item{allow.new.levels}{allow previously unobserved levels in random-effects variables? see details.}

\item{type}{Denoting \eqn{mu} as the mean of the conditional distribution and
\code{p} as the zero-inflation probability,
the possible choices are:
\describe{
\item{"link"}{conditional mean on the scale of the link function,
or equivalently the linear predictor of the conditional model}
\item{"response"}{expected value; this is \eqn{mu*(1-p)} for zero-inflated models
and \code{mu} otherwise}
\item{"conditional"}{mean of the conditional response; \code{mu} for all models
(i.e., synonymous with \code{"response"} in the absence of zero-inflation}
\item{"zprob"}{the probability of a structural zero (gives an error
for non-zero-inflated models)}
##' \item{"zilink"}{predicted zero-inflation probability on the scale of
the logit link function}
}}

\item{zitype}{deprecated: formerly used to specify type of zero-inflation probability. Now synonymous with \code{type}}

\item{na.action}{how to handle missing values in \code{newdata} (see \code{\link{na.action}});
the default (\code{na.pass}) is to predict \code{NA}}

\item{debug}{(logical) return the \code{TMBStruc} object that will be
used internally for debugging?}

\item{\dots}{unused - for method compatibility}
}
\description{
prediction
}
\details{
Prediction of new random effect levels is possible as long as the model specification (fixed effects and parameters) is kept constant.
However, to ensure intentional usage, a warning is triggered if \code{allow.new.levels=FALSE} (the default).
}
\examples{
data(sleepstudy,package="lme4")
g0 <- glmmTMB(Reaction~Days+(Days|Subject),sleepstudy)
predict(g0, sleepstudy)
## Predict new Subject
nd <- sleepstudy[1,]
nd$Subject <- "new"
predict(g0, newdata=nd, allow.new.levels=TRUE)
}
