% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apportion.R
\name{apportion}
\alias{apportion}
\title{Generate exact designs from approximate weights}
\usage{
apportion(w, n)
}
\arguments{
\item{w}{A vector of weights.}

\item{n}{The size of the exact designs to return.}
}
\value{
A named list. The names correspond to the method of rounding (see Details),
and the entries are vectors of integers indicating the count of each type of 
experimental condition.
}
\description{
Given a set of optimal weights for experimental conditions generate 
exact designs using several rounding methods.
}
\details{
Allocating `n` items to `k` groups proportionally to set of weights `w` is
known as the apportionment problem. The problem most famously arose when 
determining how many members each state should have in the U.S. House of
Representatives based on their proportion of the population. The solutions are
named after their proposers in the early U.S. Hamilton's method initially 
allocates `floor(n*w)` observations to each experimental condition and then
allocates the remaining observations based on the largest remainders `n*w - floor(n*w)`.
The other methods (Adams, Jefferson, and Webster) are divisor methods. 
The vector of counts is `m`, which is either all zeros for Jefferson and 
Webster and all ones for Adams, and we define `pi <- n*w` and then 
iteratively add observations based on the largest values of `pi/alpha` 
where `alpha` is either:
* m + 0.5 (Webster)
* m + 1 (Jefferson)
* m (Adams)
Pukelsheim and Rieder, 1996 <doi:10.2307/2337232> discuss efficient rounding
of experimental condition weights and determine that a variant of Adam's 
method is the most efficient. Results using this method are labelled "Pukelsheim"
in the output; there may be multiple designs using this procedure. Pukelsheim 
and Rieder's method assumes there is a minimum of one experimental condition 
of each type, whereas the other methods do not have this restriction.
}
\examples{
w <- c(0.45,0.03,0.02,0.02,0.03,0.45)
apportion(w,10)
}
