% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvaGlmnetFormula.r
\name{cva.glmnet}
\alias{cva.glmnet}
\alias{cva.glmnet.default}
\alias{cva.glmnet.formula}
\alias{predict.cva.glmnet}
\alias{predict.cva.glmnet.formula}
\alias{coef.cva.glmnet}
\alias{print.cva.glmnet.formula}
\alias{plot.cva.glmnet}
\alias{minlossplot}
\alias{minlossplot.cva.glmnet}
\title{Do elastic net cross-validation for alpha and lambda simultaneously}
\usage{
cva.glmnet(x, ...)

\method{cva.glmnet}{default}(
  x,
  y,
  alpha = seq(0, 1, len = 11)^3,
  nfolds = 10,
  foldid = sample(rep(seq_len(nfolds), length = nrow(x))),
  ...,
  outerParallel = NULL,
  checkInnerParallel = TRUE
)

\method{cva.glmnet}{formula}(
  formula,
  data,
  ...,
  weights = NULL,
  offset = NULL,
  subset = NULL,
  na.action = getOption("na.action"),
  drop.unused.levels = FALSE,
  xlev = NULL,
  sparse = FALSE,
  use.model.frame = FALSE
)

\method{predict}{cva.glmnet}(
  object,
  newx,
  alpha,
  which = match(TRUE, abs(object$alpha - alpha) < 1e-08),
  ...
)

\method{predict}{cva.glmnet.formula}(
  object,
  newdata,
  alpha,
  which = match(TRUE, abs(object$alpha - alpha) < 1e-08),
  na.action = na.pass,
  ...
)

\method{coef}{cva.glmnet}(
  object,
  alpha,
  which = match(TRUE, abs(object$alpha - alpha) < 1e-08),
  ...
)

\method{print}{cva.glmnet.formula}(x, ...)

\method{plot}{cva.glmnet}(x, ..., legend.x = xlim[1], legend.y = xlim[2])

minlossplot(x, ...)

\method{minlossplot}{cva.glmnet}(x, ..., cv.type = c("1se", "min"))
}
\arguments{
\item{x}{A matrix of predictor variables; or for the plotting methods, an object returned by \code{cva.glmnet}.}

\item{...}{Further arguments to be passed to lower-level functions. In the case of \code{cva.glmnet}, these arguments are passed to \code{cv.glmnet}; for \code{predict} and \code{coef}, they are passed to \code{predict.cv.glmnet}; and for \code{plot} and \code{minlossplot}, to \code{plot}.}

\item{y}{A response vector or matrix (for a multinomial response).}

\item{alpha}{A vector of alpha values for which to do cross-validation. The default is a sequence of 11 values more closely spaced around alpha = 0. For the \code{predict} and \code{coef} methods, the specific value of alpha for which to return predictions/regression coefficients.}

\item{nfolds}{The number of cross-validation folds to use. Defaults to 10.}

\item{foldid}{Vector of fold IDs for cross-validation. See \link[glmnet:cv.glmnet]{glmnet::cv.glmnet}.}

\item{outerParallel}{Method of parallelising the outer loop over alpha. See 'Details' below. If \code{NULL}, the loop is run sequentially.}

\item{checkInnerParallel}{If the outer loop is run in parallel, check that the inner loop over lambda will not be in contention for cores.}

\item{formula}{A model formula; interaction terms are allowed and will be expanded per the usual rules for linear models.}

\item{data}{A data frame or matrix containing the variables in the formula.}

\item{weights}{An optional vector of case weights to be used in the fitting process. If missing, defaults to an unweighted fit.}

\item{offset}{An optional vector of offsets, an \emph{a priori} known component to be included in the linear predictor.}

\item{subset}{An optional vector specifying the subset of observations to be used to fit the model.}

\item{na.action}{A function which indicates what should happen when the data contains missing values. For the \code{predict} method, \code{na.action = na.pass} will predict missing values with \code{NA}; \code{na.omit} or \code{na.exclude} will drop them.}

\item{drop.unused.levels}{Should factors have unused levels dropped? Defaults to \code{FALSE}.}

\item{xlev}{A named list of character vectors giving the full set of levels to be assumed for each factor.}

\item{sparse}{Should the model matrix be in sparse format? This can save memory when dealing with many factor variables, each with many levels.}

\item{use.model.frame}{Should the base \link{model.frame} function be used when constructing the model matrix? This is the standard method that most R modelling functions use, but has some disadvantages. The default is to avoid \code{model.frame} and construct the model matrix term-by-term; see \link[=glmnet.model.matrix]{discussion}.}

\item{object}{For the \code{predict} and \code{coef} methods, an object returned by \code{cva.glmnet}.}

\item{newx}{For the \code{predict} method, a matrix of predictor variables.}

\item{which}{An alternative way of specifying alpha; the index number of the desired value within the alpha vector. If both \code{which} and \code{alpha} are supplied, the former takes precedence.}

\item{newdata}{For the \code{predict} and \code{coef} methods, a data frame containing the observations for which to calculate predictions.}

\item{legend.x, legend.y}{Location for the legend. Defaults to the top-left corner of the plot.}

\item{cv.type}{For \code{minlossplot}, which cross-validated loss value to plot for each value of alpha. This can be either \code{"min"} which is the minimum loss, or \code{"1se"} which is the highest loss within 1 standard error of the minimum. The default is \code{"1se"}.}
}
\description{
Do elastic net cross-validation for alpha and lambda simultaneously
}
\details{
The \code{cva.glmnet} function does simultaneous cross-validation for both the alpha and lambda parameters in an elastic net model. The procedure is as outlined in the documentation for \link[glmnet:cv.glmnet]{glmnet::cv.glmnet}: it creates a vector \code{foldid} allocating the observations into folds, and then calls \code{cv.glmnet} in a loop over different values of alpha, but the same values of \code{foldid} each time.

Optionally this loop over alpha can be parallelised; currently, \code{cva.glmnet} knows about two methods of doing so:
\itemize{
\item Via \link{parLapply} in the parallel package. To use this, set \code{outerParallel} to a valid cluster object created by \link{makeCluster}.
\item Via \code{rxExec} as supplied by Microsoft R Server's RevoScaleR package. To use this, set \code{outerParallel} to a valid compute context created by \code{RxComputeContext}, or a character string specifying such a context.
}

If the outer loop is run in parallel, \code{cva.glmnet} can check if the inner loop (over lambda) is also set to run in parallel, and disable this if it would lead to contention for cores. This is done if it is likely that the parallelisation is local on a multicore machine, ie if \code{outerParallel} is a \code{SOCKcluster} object running on \code{"localhost"}, or if the RevoScaleR compute context is local parallel.

There are two ways in which the matrix of predictors can be generated. The default, with \code{use.model.frame = FALSE}, is to process the additive terms in the formula independently. With wide datasets, this is much faster and more memory-efficient than the standard R approach which uses the \code{model.frame} and \code{model.matrix} functions. However, the resulting model object is not exactly the same as if the standard approach had been used; in particular, it lacks a bona fide \link{terms} object. If you require interoperability with other packages that assume the standard model object structure, set \code{use.model.frame = TRUE}. See \link[=glmnet.model.matrix]{discussion} for more information on this topic.

The \code{predict} method computes predictions for a specific alpha value given a \code{cva.glmnet} object. It looks up the supplied alpha (possibly supplied indirectly via the \code{which} argument) in the object's stored \code{alpha} vector, and calls \code{glmnet:::predict.cv.glmnet} on the corresponding \code{cv.glmnet} fit. All the arguments to that function are (or should be) supported.

The \code{coef} method is similar, returning the coefficients for the selected alpha value via \code{glmnet:::coef.cv.glmnet}.

The plot method for \code{cva.glmnet} objects plots the average cross-validated loss by lambda, for each value of alpha. Each line represents one \code{cv.glmnet} fit, corresponding to one value of alpha. Note that the specific lambda values can vary substantially by alpha.

The \code{minlossplot} function gives the best (lowest) cross-validated loss for each value of alpha.
}
\section{Value}{

For \code{cva.glmnet.default}, an object of class \code{cva.glmnet}. This is a list containing the following:
\itemize{
\item \code{alpha} The vector of alpha values
\item \code{nfolds} The number of folds
\item \code{modlist} A list of \code{cv.glmnet} objects, containing the cross-validation results for each value of alpha
}

The function \code{cva.glmnet.formula} adds a few more components to the above, to facilitate working with formulas.


For the \code{predict} method, a vector or matrix of predicted values.


For the \code{coef} method, a vector of regularised regression coefficients.
}

\examples{
cva <- cva.glmnet(mpg ~ ., data=mtcars)
predict(cva, mtcars, alpha=1)

\dontrun{

# Leukemia example dataset from Trevor Hastie's website
download.file("https://web.stanford.edu/~hastie/glmnet/glmnetData/Leukemia.RData",
              "Leukemia.RData")
load("Leukemia.Rdata")
leuk <- do.call(data.frame, Leukemia)
leuk.cva <- cva.glmnet(y ~ ., leuk, family="binomial")
leuk.pred <- predict(leuk.cva, leuk, which=6)
}
}
\seealso{
\link[glmnet:cv.glmnet]{glmnet::cv.glmnet}

\link[glmnet:predict.cv.glmnet]{glmnet::predict.cv.glmnet}, \link[glmnet:predict.cv.glmnet]{glmnet::coef.cv.glmnet}

\link{cva.glmnet}, \link[glmnet:cv.glmnet]{glmnet::cv.glmnet}, \link{plot}
}
