% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.stepreg_221210.R
\name{summary.cv.stepreg}
\alias{summary.cv.stepreg}
\title{Summarize some results from a cv.stepwise() output object.}
\usage{
\method{summary}{cv.stepreg}(object, ...)
}
\arguments{
\item{object}{A cv.stepwise() output object}

\item{...}{Additional arguments passed to the summary function.}
}
\value{
Summary of a stepwise regression
}
\description{
Summarize some results from a cv.stepwise() output object.
}
\examples{
set.seed(955702213)
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=c(0,1,1))
# this gives a more interesting case but takes longer to run
xs=sim.data$xs           
# this will work numerically as an example 
xs=sim.data$xs[,c(2,3,50:55)] 
dim(xs)
y_=sim.data$yt 
event=sim.data$event
cv.stepreg.fit = cv.stepreg(xs, NULL, y_, event, steps_n=10, folds_n=3, time=0)
summary(cv.stepreg.fit)

#' 
}
