% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmnetr_230218.R
\name{glmnetr}
\alias{glmnetr}
\title{Fit relaxed part of lasso model}
\usage{
glmnetr(
  xs_tmp,
  start_tmp,
  y_tmp,
  event_tmp,
  family = "cox",
  lambda = NULL,
  gamma = c(0, 0.25, 0.5, 0.75, 1),
  object = NULL,
  track = 0,
  ties = "efron",
  time = NULL,
  ...
)
}
\arguments{
\item{xs_tmp}{predictor (X) matrix}

\item{start_tmp}{start time in case Cox model and (Start, Stop) time for use in model}

\item{y_tmp}{outcome (Y) variable, in case of Cox model (stop) time}

\item{event_tmp}{event variable in case of Cox model}

\item{family}{one of "cox", "gaussian" or "binomial"}

\item{lambda}{lambda vector, as in glmnet(), default is NULL}

\item{gamma}{gamma vector, as with glmnet(), default c(0,0.25,0.50,0.75,1)}

\item{object}{an output object from glmnet() using relax=FALSE with the model fits for
the fully penalized lasso models, i.e. gamma=1.  Default is NULL in which case these are derived 
within the function.}

\item{track}{Indicate whether or not to update progress in the console.  Default of
0 suppresses these updates.  The option of 1 provides these updates.  In fitting 
clinical data with non full rank design matrix we have found some R-packages to
take a vary long time or possibly get caught in infinite loops.  Therefore we allow
the user to track the package and judge whether things are moving forward or 
if the process should be stopped.}

\item{ties}{method for handling ties in Cox model for relaxed model component.  Default 
is "efron", optionally "breslow".  For penalized fits "breslow" is 
always used as in the 'glmnet' package.}

\item{time}{track progress by printing to console elapsed and split times.  Suggested to use
track option instead as time options will be eliminated.}

\item{...}{Additional arguments that can be passed to glmnet()}
}
\value{
A list with two matrices, one for the model coefficients with
    gamma=1 and the other with gamma=0.
}
\description{
Derive the relaxed lasso fits and optionally calls glmnet() to 
derive the fully penalized lasso fit.
}
\examples{
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=200, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
glmnetr.fit = glmnetr( xs, NULL, y_, event, family="cox")
plot(glmnetr.fit)

}
\seealso{
\code{\link{cv.glmnetr}} , \code{\link{nested.glmnetr}}  , \code{\link{glmnetr.simdata}}
}
