% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.glmnetr_250404.R
\name{predict.cv.glmnetr}
\alias{predict.cv.glmnetr}
\title{Give predicteds for elastic net models form a nested.glmnetr() output object.}
\usage{
\method{predict}{cv.glmnetr}(
  object,
  xs_new = NULL,
  alpha = NULL,
  gamma = NULL,
  lambda = NULL,
  type = "lasso",
  comment = TRUE,
  ...
)
}
\arguments{
\item{object}{A cv.glmnetr (or nested.glmnetr) output object.}

\item{xs_new}{The predictor matrix.  If NULL, then betas are provided.}

\item{alpha}{A specific value of alpha for plotting.  Used only when type is 
set to "elastic". Specifies which alpha is to be used for deviance plots.
Default is "alpha.min", else must be an element of the alpha vector used in 
running the elastic net model. This can be reviewed using summary(fit) 
where fit is a nested.glmnetr() output object. Note, alpha is 1 for the 
lasso model and alpha is 0 for the ridge model.}

\item{gamma}{The gamma value for choice of beta.  If NULL, then 
gamma.min is used from the cross validated tuned relaxed model.  We
use the term gam instead of gamma as gamma usually denotes a vector 
in the package.}

\item{lambda}{The lambda value for choice of beta.  If NULL, then 
lambda.min is used from the cross validated tuned relaxed model.  We
use the term lam instead of lambda as lambda usually denotes a vector 
in the package.}

\item{type}{type of model on which to base predictds. One of "lasso", "ridge" 
and "elastic" if elastic net model is fit.}

\item{comment}{Default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the predict function.}
}
\value{
Either predicteds (xs_new*beta estimates based upon the predictor matrix xs_new)  
or model coefficients, based upon a cv.glmnetr() output object.  When 
outputting coefficients (beta), creates a list 
with the first element, beta_, including 0 and non-0 terms and the 
second element, beta, including only non 0 terms.
}
\description{
Give predicteds based upon a cv.glmnetr() output object. By default lambda and gamma 
are chosen as the minimizing values for the relaxed lasso model.  If gam=1 and lam=NULL 
then the best unrelaxed lasso model is chosen and if gam=0 and lam=NULL then
the best fully relaxed lasso model is selected.
}
\seealso{
\code{\link{summary.cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
