% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.nested.glmnetr_250504.R
\name{predict.nested.glmnetr}
\alias{predict.nested.glmnetr}
\title{Give predicteds based upon the cv.glmnet output object contained in the 
nested.glmnetr output object.}
\usage{
\method{predict}{nested.glmnetr}(
  object,
  xs_new = NULL,
  alpha = NULL,
  gamma = NULL,
  lambda = NULL,
  type = "lasso",
  comment = TRUE,
  ...
)
}
\arguments{
\item{object}{A nested.glmnetr output object.}

\item{xs_new}{The predictor matrix.  If NULL, then betas are provided.}

\item{alpha}{A specific value of alpha for plotting.  Used only when type is 
set to "elastic". Specifies which alpha is to be used for deviance plots.
Default is "alpha.min", else must be an element of the alpha vector used in 
running the elastic net model. This can be reviewed using summary(fit) 
where fit is a nested.glmnetr() output object. Note, alpha is 1 for the 
lasso model and alpha is 0 for the ridge model.}

\item{gamma}{The gamma value for choice of beta.  If NULL, then 
gamma.min is used from the cross validation informed relaxed model.  We
use the term gam instead of gamma as gamma usually denotes a vector 
in the package.}

\item{lambda}{The lambda value for choice of beta.  If NULL, then 
lambda.min is used from the cross validation informed relaxed model.  We
use the term lam instead of lambda as lambda usually denotes a vector 
in the package.}

\item{type}{type of model on which to base predictds. One of "lasso", "ridge" 
and "elastic" if elastic net model is fit.}

\item{comment}{Default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the predict function.}
}
\value{
Either the xs_new*Beta estimates based upon the predictor matrix, 
or model coefficients.
}
\description{
This is essentially a redirect to the summary.cv.glmnetr
function for nested.glmnetr output objects, based uopn the cv.glmnetr
output object contained in the nested.glmnetr output object.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3) 
betas = predict(fit3)
betas$beta
}

}
\seealso{
\code{\link{predict.cv.glmnetr}} , \code{\link{predict_ann_tab}} , \code{\link{nested.glmnetr}}
}
