% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{RJC}
\alias{RJC}
\title{Rotnitzky–Jewell's Criterion for Generalized Estimating Equations}
\usage{
RJC(...)
}
\arguments{
\item{...}{one or several objects of the class glmgee which are obtained from the fit of generalized estimating equations.}
}
\value{
A matrix with the values of the RJC for each glmgee object provided in the input.
}
\description{
Computes the Rotnitzky–Jewell's criterion (RJC) for one or more objects of the class glmgee.
}
\examples{
## Example 1
mod <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="AR-1")
fit2 <- update(fit1, corstr="Exchangeable")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
RJC(fit1, fit2, fit3, fit4)

## Example 2
mod <- dep ~ visit + group
fit1 <- glmgee(mod, id=subj, family=gaussian, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="Exchangeable")
fit3 <- update(fit1, corstr="Non-Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
RJC(fit1, fit2, fit3, fit4)

## Example 3
mod <- depressd ~ visit + group
fit1 <- glmgee(mod, id=subj, family=binomial, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="Exchangeable")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
RJC(fit1, fit2, fit3, fit4)
}
\references{
Hin L-Y, Carey V.J., Wang Y-G (2007) Criteria for Working–Correlation–Structure Selection in GEE:
Assessment via Simulation. \emph{The American Statistician} 61, 360–364.
}
\seealso{
\link{QIC}, \link{CIC}, \link{DEW}
}
