% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{wglmgee}
\alias{wglmgee}
\title{Fit Weighted Generalized Estimating Equations}
\usage{
wglmgee(
  formula,
  level = c("observations", "clusters"),
  family = gaussian(),
  weights,
  id,
  data,
  subset,
  corstr,
  corr,
  start = NULL,
  scale.fix = FALSE,
  scale.value = 1,
  toler = 1e-05,
  maxit = 50,
  trace = FALSE,
  ...
)
}
\arguments{
\item{formula}{an \code{Formula} expression of the form \code{response ~ x1 + x2 + ... | z1 + z2 + ...}, whose first part is a symbolic description of the linear predictor of the GEE model to be fitted to the data, whereas the second part is a symbolic description of the linear predictor of the logistic model to be used to calculate the missingness probabilities under the MAR assumption. Then, those probabilities are used to computed the weights to be included in the parameter estimation algorithm.}

\item{level}{an (optional) character string which allows to specify the weighted GEE method. The available options are: "observations" and "clusters" for Observation- and Cluster-specified Weighted GEE, respectively. By default, \emph{level} is set to be "observations".}

\item{family}{an (optional) \code{family} object, that is, a list of functions and expressions for defining link and variance functions. Families (and links) supported are the same supported by \link{glm} using its \link{family} argument, that is,
\code{gaussian}, \code{binomial}, \code{poisson}, \code{Gamma}, \code{inverse.gaussian}, and \code{quasi}. The family \code{negative.binomial} in the library \pkg{MASS} are also available. By default, the argument \code{family} is set to be \code{gaussian(identity)}.}

\item{weights}{an (optional) vector of positive "prior weights" to be used in the fitting process. The length of \code{weights} should be the same as the total number of observations.}

\item{id}{a vector which identifies the subjects or clusters. The length of \code{id} should be the same as the number of observations.}

\item{data}{an (optional) \code{data frame} in which to look for variables involved in the \code{formula} expression, as well as for variables specified in the arguments \code{id} and \code{weights}. The data are assumed to be sorted by \code{id} and time.}

\item{subset}{an (optional) vector specifying a subset of observations to be used in the fitting process.}

\item{corstr}{an (optional) character string which allows to specify the working-correlation structure. The available options are: "Independence", "Unstructured", "Stationary-M-dependent(\emph{m})", "Non-Stationary-M-dependent(\emph{m})", "AR-M-dependent(\emph{m})", "Exchangeable" and "User-defined", where \emph{m} represents the lag of the dependence. By default, \code{corstr} is set to be "Independence".}

\item{corr}{an (optional) square matrix of the same dimension of the maximum cluster size containing the user specified correlation. This is only appropriate if \code{corstr} is specified to be "User-defined".}

\item{start}{an (optional) vector of starting values for the parameters in the linear predictor.}

\item{scale.fix}{an (optional) logical variable. If TRUE, the scale parameter is fixed at the value of \code{scale.value}. By default, \code{scale.fix} is set to be FALSE.}

\item{scale.value}{an (optional) numeric value at which the scale parameter should be fixed. This is only appropriate if \code{scale.fix=TRUE}. By default, \code{scale.value} is set to be 1.}

\item{toler}{an (optional) positive value which represents the \emph{convergence tolerance}. The convergence is reached when the maximum of the absolute relative differences between the values of the parameters in the linear predictor in consecutive iterations of the fitting algorithm is lower than \code{toler}. By default, \code{toler} is set to be 0.00001.}

\item{maxit}{an (optional) integer value which represents the maximum number of iterations allowed for the fitting algorithm. By default, \code{maxit} is set to be 50.}

\item{trace}{an (optional) logical variable. If TRUE, output is produced for each iteration of the estimating algorithm.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of class \emph{wglmgee} in which the main results of the weighted GEE model fitted to the data are stored,
i.e., a list with components including
\tabular{ll}{
\code{coefficients} \tab a vector with the estimates of \eqn{\beta_1,\ldots,\beta_p},\cr
\tab \cr
\code{fitted.values}\tab a vector with the estimates of \eqn{\mu_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{start}        \tab a vector with the starting values used,\cr
\tab \cr
\code{iter}         \tab a numeric constant with the number of iterations,\cr
\tab \cr
\code{prior.weights}\tab a vector with the values of \eqn{\omega_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{offset}       \tab a vector with the values of \eqn{z_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{terms}        \tab an object containing the terms objects,\cr
\tab \cr
\code{estfun}       \tab a vector with the estimating equations evaluated at the parameter\cr
                    \tab estimates and the observed data,\cr
\tab \cr
\code{formula}      \tab the formula,\cr
\tab \cr
\code{levels}       \tab the levels of the categorical regressors,\cr
\tab \cr
\code{contrasts}    \tab an object containing the contrasts corresponding to levels,\cr
\tab \cr
\code{converged}    \tab a logical indicating successful convergence,\cr
\tab \cr
\code{model}        \tab the full model frame,\cr
\tab \cr
\code{y}            \tab a vector with the values of \eqn{y_{ij}} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{family}       \tab an object containing the \link{family} object used,\cr
\tab \cr
\code{linear.predictors} \tab a vector with the estimates of \eqn{g(\mu_{ij})} for \eqn{i=1,\ldots,n} and \eqn{j=1,\ldots,n_i},\cr
\tab \cr
\code{R}            \tab a matrix with the (robust) estimate of the variance-covariance,\cr
\tab \cr
\code{corr}         \tab a matrix with the estimate of the working-correlation,\cr
\tab \cr
\code{corstr}       \tab a character string specifying the working-correlation structure,\cr
\tab \cr
\code{level}        \tab a character string specifying the weighted GEE method,\cr
\tab \cr
\code{id}           \tab a vector which identifies the subjects or clusters,\cr
\tab \cr
\code{sizes}        \tab a vector with the values of \eqn{n_i} for \eqn{i=1,\ldots,n},\cr
\tab \cr
\code{call}         \tab the original function call,\cr
}
}
\description{
Produces an object of the class \code{wglmgee} in which the main results of a Weighted Generalized Estimating Equation (WGEE) fitted to the data are stored.
}
\details{
The values of the multivariate response variable measured on \eqn{n} subjects or clusters,
denoted by \eqn{y_{i}=(y_{i1},\ldots,y_{in_i})^{\top}} for \eqn{i=1,\ldots,n}, are assumed to be
realizations of independent random vectors denoted by \eqn{Y_{i}=(Y_{i1},\ldots,Y_{in_i})^{\top}}
for \eqn{i=1,\ldots,n}. The random variables associated to the \eqn{i}-th subject or
cluster, \eqn{Y_{ij}} for \eqn{j=1,\ldots,n_i}, are assumed to satisfy
\eqn{\mu_{ij}=} E\eqn{(Y_{ij})},Var\eqn{(Y_{ij})=\frac{\phi}{\omega_{ij}}}V\eqn{(\mu_{ij})}
and Corr\eqn{(Y_{ij},Y_{ik})=r_{jk}(\rho)},
where \eqn{\phi>0} is the dispersion parameter,
V\eqn{(\mu_{ij})} is the variance function, \eqn{\omega_{ij}>0} is a known weight, and
\eqn{\rho=(\rho_1,\ldots,\rho_q)^{\top}} is a parameter vector.
In addition, \eqn{\mu_{ij}} is assumed to be dependent on the regressors vector \eqn{x_{ij}}
by \eqn{g(\mu_{ij})=z_{ij} + x_{ij}^{\top}\beta}, where \eqn{g(\cdot)} is the link function,
\eqn{z_{ij}} is a known \emph{offset} and \eqn{\beta=(\beta_1,\ldots,\beta_p)^{\top}} is
a vector of regression parameters. The probabilities \eqn{Pr[T_{ij}=1|T_{i,j-1}=1,x_{i1},\ldots,x_{ij},Y_{i1},\ldots,Y_{i,j-1}]}
are estimated by using a logistic model whose covariates are given by \eqn{z_{1},\ldots,z_{r}}. Then, those
probabilities are used to computed the weights to be included in the parameter estimation algorithm.

A set of standard extractor functions for fitted model objects is available for objects of class  \emph{glmgee},
including methods to the generic functions such as \code{print}, \code{summary},	\code{model.matrix}, \code{estequa},
\code{coef}, \code{vcov}, \code{fitted}, \code{confint} and \code{predict}. The input data are assumed to be ordered
in time within each cluster.
}
\examples{
###### Example: Amenorrhea rates over time
data(amenorrhea)
amenorrhea2 <- within(amenorrhea,{
							 Ctime <- factor(Time)
							 Ctime <- relevel(Ctime,ref="1")
							 ylag1 <- c(0,amenorrhea[-length(ID)])
							 ylag1 <- ifelse(Time==0,0,ylag1)})

mod <- amenorrhea ~ poly(Time,2) + Dose | Ctime + Dose + ylag1

### Observation-specified Weighted GEE
fit1 <- wglmgee(mod, family=binomial, data=amenorrhea2, id=ID,
                corstr="AR-M-dependent(1)", level="observations")
summary(fit1)

### Cluster-specified Weighted GEE
fit2 <- wglmgee(mod, family=binomial, data=amenorrhea2, id=ID,
                corstr="Exchangeable", level="clusters")
summary(fit2)

}
\references{
Fitzmaurice G.M., Laird N.M., Ware J.H. (2011). \emph{Applied Longitudinal Analysis. 2nd ed.} John Wiley & Sons.

Preisser J.S., Lohman K.K., Rathouz P.J. (2002). Performance of Weighted Estimating Equations for
Longitudinal Binary Data with Drop-Outs Missing at Random. \emph{Statistics in Medicine} 21:3035–3054.

Robins J.M., Rotnitzky A., Zhao L.P. (1995) Analysis of Semiparametric Regression Models for Repeated
Outcomes in the Presence of Missing Data. \emph{Journal of the American Statistical Association} 90:122–129.
}
\seealso{
\link{glmgee}, \link{gnmgee}
}
