% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\title{Generate data from Gaussian, logistic and Poisson models.}
\usage{
models(
  family = c("gaussian", "binomial", "poisson"),
  type = c("all", "source", "target"),
  h = 5,
  K = 5,
  n.target = 100,
  n.source = rep(150, K),
  s = 15,
  p = 1000,
  Ka = K
)
}
\arguments{
\item{family}{response type. Can be "gaussian", "binomial" or "poisson". Default = "gaussian".
\itemize{
\item "gaussian": Gaussian distribution.
\item "binomial": logistic distribution. When \code{family = "binomial"}, the input response in both \code{target} and \code{source} should be 0/1.
\item "poisson": poisson distribution. When \code{family = "poisson"}, the input response in both \code{target} and \code{source} should be non-negative.
}}

\item{type}{the type of generated data. Can be "all", "source" or "target".
\itemize{
\item "all": generate a list with a target data set of size \code{n.target} and K source data set of size \code{n.source}.
\item "source": generate a list with K source data set of size \code{n.source}.
\item "target": generate a list with a target data set of size \code{n.target}.
}}

\item{h}{measures the deviation (\eqn{l_1}-norm) of transferable source coefficient from the target coefficient.}

\item{K}{the number of source data sets. Default = 5.}

\item{n.target}{the sample size of target data. Should be a positive integer. Default = 100.}

\item{n.source}{the sample size of each source data. Should be a vector of length \code{K}. Default is a \code{K}-vector with all elements 150.}

\item{s}{how many components in the target coefficient are non-zero, which controls the sparsity of target problem. Default = 15.}

\item{p}{the dimension of data. Default = 1000.}

\item{Ka}{the number of transferable sources. Should be an integer between 0 and \code{K}. Default = K.}
}
\value{
a list of data sets which depend on the value of \code{type}.
\itemize{
\item \code{type} = "all": a list of two components named "target" and "source" storing the target and source data, respectively. Component source is a list containing \code{K} components with the first \code{Ka} ones \code{h}-transferable and the remaining ones \code{h}-nontransferable. The target data set and each source data set have components "x" and "y", as the predictors and responses, respectively.
\item \code{type} = "source": a list with a signle component "source". This component contains a list of \code{K} components with the first \code{Ka} ones \code{h}-transferable and the remaining ones \code{h}-nontransferable. Each source data set has components "x" and "y", as the predictors and responses, respectively.
\item \code{type} = "target": a list with a signle component "target". This component contains another list with components "x" and "y", as the predictors and responses of target data, respectively.
}
}
\description{
Generate data from Gaussian, logistic and Poisson models used in the simulation part of Tian, Y. and Feng, Y., 2021.
}
\examples{
set.seed(1, kind = "L'Ecuyer-CMRG")

D.all <- models("binomial", type = "all")
D.target <- models("binomial", type = "target")
D.source <- models("binomial", type = "source")

}
\references{
Tian, Y. and Feng, Y., 2021. \emph{Transfer learning with high-dimensional generalized linear models. Submitted.}
}
\seealso{
\code{\link{glmtrans}}.
}
