% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_functions.r
\name{initialize_db}
\alias{initialize_db}
\title{Initialize database}
\usage{
initialize_db()
}
\value{
Database is created.
}
\description{
The function creates a new database for the \code{globaltrends} package and
creates all necessary tables within the database.
}
\details{
The function creates a new SQLite database for the \code{globaltrends}
package. The database is saved as file \emph{db/globaltrends_db.sqlite} in
the working directory. If the folder \emph{db} does not exists in the working
directory, the folder is created. If the database already exists in the
working directory, the function exits with an error. Within the database all
tables are created and the default location sets are added to the respective
table:
\itemize{
\item \emph{countries} - all countries with a share in global GDP >= 0.1\\%
in 2018.
\item \emph{us_states} - all US federal states and Washington DC.
}
After creating the database, the function disconnects from the database.
}
\section{Warning}{

SQLite databases only allow one writer at any instant in time. To run
parallel downloads use one database for each download client and merge them
once all downloads are complete.
}

\examples{
\dontrun{
initialize_db()
}

}
\seealso{
\itemize{
\item \code{\link[=start_db]{start_db()}}
\item \code{\link[=disconnect_db]{disconnect_db()}}
\item \code{\link[=example_keywords]{example_keywords()}}
\item \code{\link[=example_time]{example_time()}}
\item \code{\link[=example_control]{example_control()}}
\item \code{\link[=example_object]{example_object()}}
\item \code{\link[=example_score]{example_score()}}
\item \code{\link[=example_doi]{example_doi()}}
\item \url{https://www.sqlite.org/index.html}
}
}
