% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_absences.R
\name{generate_pa_buffer_out}
\alias{generate_pa_buffer_out}
\title{Generate Pseudo-Absences Using Buffer-Out Strategy}
\usage{
generate_pa_buffer_out(
  presences,
  raster_stack,
  predictor_variables,
  coords = c("decimalLongitude", "decimalLatitude"),
  pa_buffer_distance = 0.5,
  ratio = 1,
  attempts = 100,
  seed = NULL
)
}
\arguments{
\item{presences}{Data frame containing presence points.}

\item{raster_stack}{`SpatRaster` object containing covariate data.}

\item{predictor_variables}{Character vector of the predictor variables selected for this species.}

\item{coords}{Character vector specifying the column names for latitude and longitude. Defaults to `c("decimalLongitude", "decimalLatitude")`.}

\item{pa_buffer_distance}{Numeric; buffer radius in degrees around each presence. Default is 0.5.}

\item{ratio}{Ratio of pseudo-absences to presences (default 1 = balanced).}

\item{attempts}{Integer specifying the number of attempts to generate exact pseudo-absences. Defaults to 100.}

\item{seed}{Optional seed for reproducibility.}
}
\value{
A data frame of pseudo-absences with coordinates, timestamp, `pa = 0`, and covariate values.
}
\description{
This function generates pseudo-absences outside a buffer around presence points but within
the convex hull of those points. This prevents spatial overlap while preserving geographic realism.
}
