% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottojoin.R
\name{glottojoin}
\alias{glottojoin}
\title{Join glottodata with other objects, datasets, or databases.}
\usage{
glottojoin(glottodata, with = NULL, id = NULL, rm.na = FALSE, type = "left")
}
\arguments{
\item{glottodata}{glottodata or glottosubdata}

\item{with}{Optional: glottodata (class data.frame), a dist object (class dist), or the name of a glottodatabase ("glottobase" or "glottospace")}

\item{id}{By default, data is joined by a column named "glottocode" or "glottosubcode". In case you want to join using another column, the column name should be specified.}

\item{rm.na}{Only used when joining with a dist object. By default NAs are kept.}

\item{type}{In case two glottodata objects are joined, you can specify the type of join: "left" (default), "right", "full", or "inner"}
}
\value{
glottodata or glottosubdata, either with or without metatables. Object is returned as a data.frame or list, depending on the input.
}
\description{
Join glottodata with other objects, datasets, or databases.
}
\examples{
\donttest{
glottodata <- glottoget("demodata")
glottodata_space <- glottojoin(glottodata, with = "glottospace")
glottodata_base <- glottojoin(glottodata, with = "glottobase")

# Join with a dist object
glottodata <- glottoget("demodata", meta = TRUE)
dist <- glottodist(glottodata)
glottodata_dist <- glottojoin(glottodata, with = dist)

# Join glottosubdata tables:
glottosubdata <- glottocreate(glottocodes = c("yucu1253", "tani1257"),
variables = 3, groups = c("a", "b"), n = 2, meta = FALSE)
glottodatatable <- glottojoin(glottodata = glottosubdata)
}
}
\seealso{
glottosplit
}
