% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{glue_collapse}
\alias{glue_collapse}
\title{Collapse a character vector}
\usage{
glue_collapse(x, sep = "", width = Inf, last = "")
}
\arguments{
\item{x}{The character vector to collapse.}

\item{sep}{a character string to separate the terms.  Not
    \code{\link{NA_character_}}.}

\item{width}{The maximum string width before truncating with \code{...}.}

\item{last}{String used to separate the last two items if \code{x} has at least
2 items.}
}
\description{
Collapses a character vector of any length into a length 1 vector.
}
\examples{
glue_collapse(glue("{1:10}"))

# Wide values can be truncated
glue_collapse(glue("{1:10}"), width = 5)

glue_collapse(1:4, ",", last = " and ")
#> 1, 2, 3 and 4
}
