% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-heading.R
\name{md_setext}
\alias{md_setext}
\title{Markdown Setext headings (4.3)}
\usage{
md_setext(x, level = 1, width = TRUE)
}
\arguments{
\item{x}{A character vector of heading text.}

\item{level}{An numeric vector of all either 1 or 2 to determine whether
level 1 headings are created with \code{=} or level two with \code{-}. If less levels
are provided than headings, \code{level} will be repeated via \code{\link[glue:glue]{glue::glue()}}.}

\item{width}{logical or integer; if \code{TRUE} the width will be automatically
determined by the width of the longest line in \code{x}. If an integer, the
setext underline will be that wide.}
}
\value{
A \code{glue} vector of headings with length equal to \code{x}.
}
\description{
Turn a character vector into a vector of valid markdown Setext headings.
These markdown leaf blocks can be rendered as the \verb{<h1>} and \verb{<h2>} tags
\emph{only}.
}
\details{
A setext heading consists of one or more lines of text, each containing at
least one non-whitespace character, with no more than 3 spaces indentation,
followed by a setext heading underline. The lines of text must be such that,
were they not followed by the setext heading underline, they would be
interpreted as a paragraph: they cannot be interpretable as a
\href{https://github.github.com/gfm/#code-fence}{code fence},
\href{https://github.github.com/gfm/#atx-headings}{ATX heading},
\href{https://github.github.com/gfm/#block-quotes}{block quote},
\href{https://github.github.com/gfm/#thematic-breaks}{thematic break},
\href{https://github.github.com/gfm/#list-items}{list item}, or
\href{https://github.github.com/gfm/#html-blocks}{HTML block.}

A setext heading underline is a sequence of \code{=} characters or a sequence of
\code{-} characters, with no more than 3 spaces indentation and any number of
trailing spaces. If a line containing a single \code{-} can be interpreted as an
empty list items, it should be interpreted this way and not as a setext
heading underline.

The heading is a level 1 heading if \code{=} characters are used in the setext
heading underline, and a level 2 heading if \code{-} characters are used. The
contents of the heading are the result of parsing the preceding lines of text
as CommonMark inline content.

In general, a setext heading need not be preceded or followed by a blank
line. However, it cannot interrupt a paragraph, so when a setext heading
comes after a paragraph, a blank line is needed between them.
}
\examples{
md_setext("Overview")
md_setext("This is a setext\nheading", level = 2)
md_setext(c("one", "two", "three", "four"), level = c(1, 2))
md_setext("Installation", level = 2, width = 55)
}
\seealso{
Other leaf block functions: 
\code{\link{md_blank}()},
\code{\link{md_chunk}()},
\code{\link{md_fence}()},
\code{\link{md_heading}()},
\code{\link{md_indent}()},
\code{\link{md_label}()},
\code{\link{md_paragraph}()},
\code{\link{md_reference}()},
\code{\link{md_rule}()},
\code{\link{md_table}()}
}
\concept{leaf block functions}
