% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{em}
\alias{em}
\title{Estimate the parameters of a Gaussian mixture model}
\usage{
em(
  gmm,
  data,
  regul = NULL,
  epsilon = 1e-06,
  max_iter_em = Inf,
  verbose = FALSE
)
}
\arguments{
\item{gmm}{An initial object of class \code{gmm}.}

\item{data}{A data frame or numeric matrix containing the data used in the
EM algorithm. Its columns must explicitly be named after the variables of
\code{gmm} and must not contain missing values.}

\item{regul}{A positive numeric value corresponding to the regularization
constant if a Bayesian regularization is applied. If \code{NULL} (the
default), no regularization is applied.}

\item{epsilon}{A positive numeric value corresponding to the convergence
threshold for the increase in log-likelihood.}

\item{max_iter_em}{A non-negative integer corresponding to the maximum number
of iterations.}

\item{verbose}{A logical value indicating whether iterations in progress
are displayed.}
}
\value{
A list with elements:
\item{gmm}{The final \code{gmm} object.}
\item{posterior}{A numeric matrix containing the posterior probabilities for
each observation.}
\item{seq_loglik}{A numeric vector containing the sequence of log-likelihoods
measured initially and after each iteration.}
}
\description{
This function estimates the parameters of a Gaussian mixture model using the
expectation-maximization (EM) algorithm. Given an initial model, this
algorithm iteratively updates the parameters, monotonically increasing the
log-likelihood until convergence to a local maximum (Bilmes, 1998). A
Bayesian regularization can be applied during the process to prevent that a
mixture component comes down to a single point and leads to a zero covariance
matrix (Ormoneit and Tresp, 1996). Although the EM algorithm only applies to
the joint model, good parameters can be found for a derived conditional
model. However, care should be taken as the monotonic increase of the
conditional log-likelihood is not guaranteed.
}
\examples{
data(data_body)
gmm_1 <- split_comp(add_var(NULL,
                            data_body[, c("WAIST", "AGE", "FAT", "HEIGHT",
                                          "WEIGHT")]),
                    n_sub = 3)
res_em <- em(gmm_1, data_body, regul = 0.01, max_iter_em = 100, verbose = TRUE)

}
\references{
Bilmes, J. A. (1998). A Gentle Tutorial of the EM Algorithm and its
Application to Parameter Estimation for Gaussian Mixture and Hidden Markov
Models. Technical report, International Computer Science Institute.

Ormoneit, D. and Tresp, V. (1996). Improved Gaussian Mixture Density
Estimates Using Bayesian Penalty Terms and Network Averaging. In
\emph{Advances in Neural Information Processing Systems 8}, pages 542--548.
}
\seealso{
\code{\link{smem}}, \code{\link{stepwise}}
}
