% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmix.R
\name{rmix}
\alias{rmix}
\title{Normal mixture model generator.}
\usage{
rmix(n, pi, mu, sigma)
}
\arguments{
\item{n}{Number of observations.}

\item{pi}{A g-dimensional vector for the initial values of the mixing proportions.}

\item{mu}{A \eqn{p \times g} matrix for the initial values of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix,or a list of g covariance matrices with dimension \eqn{p\times p \times g}.
It is assumed to fit the model with a common covariance matrix if \code{sigma} is a \eqn{p\times p} covariance matrix;
otherwise it is assumed to fit the model with unequal covariance matrices.}
}
\value{
\item{Y}{An \eqn{n\times p} numeric matrix with samples drawn in rows.}
\item{Z}{ An \eqn{n\times g} numeric matrix; each row represents zero-one indicator variables defining the known class of origin of each.}
\item{clust}{An n-dimensional vector of class partition.}
}
\description{
Generate random observations from the normal mixture distributions.
}
\examples{
n<-150
pi<-c(0.25,0.25,0.25,0.25)
sigma<-array(0,dim=c(3,3,4))
sigma[,,1]<-diag(1,3)
sigma[,,2]<-diag(2,3)
sigma[,,3]<-diag(3,3)
sigma[,,4]<-diag(4,3)
mu<-matrix(c(0.2,0.3,0.4,0.2,0.7,0.6,0.1,0.7,1.6,0.2,1.7,0.6),3,4)
dat<-rmix(n=n,pi=pi,mu=mu,sigma=sigma)
}
