% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{vcov.gmnl}
\alias{vcov.gmnl}
\title{vcov method for gmnl objects}
\usage{
\method{vcov}{gmnl}(object, what = c("coefficient", "ranp"), type = c("cov",
  "cor", "sd"), se = FALSE, Q = NULL, digits = max(3, getOption("digits")
  - 2), ...)
}
\arguments{
\item{object}{a fitted model of class \code{gmnl},}

\item{what}{indicates which covariance matrix has to be extracted. The default is \code{coefficient}, in this case the \code{vcov} behaves as usual. If \code{what = "ranp"} the covariance matrix of the random parameters is returned as default,}

\item{type}{if the model is estimated with random parameters, then this argument indicates what matrix should be returned. If \code{type = "cov"}, then the covariance matrix of the random parameters is returned; if \code{type = "cor"} then the correlation matrix of the random parameters is returned; if \code{type = "sd"} then the standard deviation of the random parameters is returned,}

\item{se}{if \code{TRUE} \code{type = "cov"} then the standard error of the covariance matrix of the random parameters is returned; if \code{TRUE} \code{type = "sd"} the standard error of the standard deviation of the random parameter is returned. This argument if valid only if the model is estimated using correlated random parameters,}

\item{Q}{this argument is only valid if the "\code{mm}" (MM-MNL) model is estimated. It indicates the class for which the variance-covariance matrix is computed,}

\item{digits}{number of digits,}

\item{...}{further arguments}
}
\description{
The \code{vcov} method for \code{gmnl} objects extracts the covariance matrix of the coefficients or the random parameters. It also allows to get the standard errors for the variance-covariance matrix of the random parameters
}
\details{
This new interface replaces the \code{cor.gmnl}, \code{cov.gmnl} and \code{se.cov.gmnl} functions which are deprecated.
}
\seealso{
\code{\link[gmnl]{gmnl}} for the estimation of multinomial logit models with random parameters.
}

