% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cec.R
\name{CEC}
\alias{CEC}
\title{Cross-Entropy Clustering}
\usage{
CEC(x = NULL, k = 0, method.type = "standard", method.init = "kmeans++",
  params.r = 0, params.cov = matrix(0), params.centroids = NULL,
  params.mix = NULL, params.function = NULL, control.nstart = 10,
  control.eps = 0.05, control.itmax = 25, log.energy = TRUE,
  log.ncluster = TRUE, seed = NULL)
}
\arguments{
\item{x}{Numeric matrix of data.}

\item{k}{Initial number of clusters.}

\item{method.type}{Type of clustering (Gaussian family).
\enumerate{
\item 'diagonal' Gaussians with diagonal covariance. The clustering will try to divide the data into ellipsoid with radiuses parallel to coordinate axes
\item 'fixed_spherical' Spherical (radial) Gaussian densities (additional parameter - radius)
\item 'fixed_covariance' The clustering will have the tendency to divide the data into clusters resembling the unit circles in the Mahalanobis distance (additional parameter - covaraince matrix required)
\item 'func' Own function dependent on m and sigma (additional parameter)
\item 'standard' We divide dataset into ellipsoid-like clusters without any preferences (default)
\item 'spherical' The clustering will try to divide the data into circles of arbitrary sizes}}

\item{method.init}{Method to initialize clusters.
\enumerate{
\item 'centroids'
\item 'kmeans++'
\item 'random'}}

\item{params.r}{Radius for spherical family.}

\item{params.cov}{Covariance matrix for covariance family.}

\item{params.centroids}{List of centroids.}

\item{params.mix}{List of cluster with mixed Gaussian types.}

\item{params.function}{User energy function}

\item{control.nstart}{How many times to perform algorithm.}

\item{control.eps}{What change of value should terminate algorithm.}

\item{control.itmax}{Maximum number of iterations at each start.}

\item{log.energy}{Records collected energy of all clusters in each iteration.}

\item{log.ncluster}{Records number of clusters in each iteration.}

\item{seed}{User seed}
}
\description{
Create CEC model object
}
\examples{
\dontrun{
CEC(k=3, x=dataset)

CEC(k=3, x=dataset, control.nstart=10, method.type='spherical', control.eps=0.05)

CEC(k=2, x=dataset, method.type='spherical', method.init='centroids',
   params.centroids=list(c(-0.5,0.5),c(0,0)))

CEC(k=5, x=dataset, method.type='fixed_spherical', params.r=0.01,
   control.nstart=10, control.eps=0.07)

CEC(k=5, x=dataset, method.type='fixed_covariance',
   params.cov=matrix(c(0.03,0,0,0.01),2), control.nstart=10, control.eps=0.06)

CEC(k=1, x=dataset, method.type='func',
   params.function='name_of_my_own_function')

fixed_spherical_cluster_param = list(method.type = 'fixed_spherical', params.r = 0.001),
covariance_cluster_param = list(method.type = 'fixed_covariance',
   params.cov=matrix(c(0.05, 0, 0, 0.001), 2))
CEC(x = dataset, params.mix = list(covariance_cluster_param,
   fixed_spherical_cluster_param, fixed_spherical_cluster_param,
   fixed_spherical_cluster_param, fixed_spherical_cluster_param), control.nstart = 10)

p1 = list(method.type='spherical', k=3)
p2 = list(method.type='diagonal', k=2)
CEC(x=dataset, params.mix=list(p1, p2))
}
}

