% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{regime_distance}
\alias{regime_distance}
\title{Calculate "distance" between two (scaled) regimes \strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}}
\usage{
regime_distance(p, M, d, regime_pars1, regime_pars2)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{number of time series in the system, i.e. the dimension.}

\item{regime_pars1}{a length \eqn{pd^2+d+d(d+1)/2} vector
\strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}.}

\item{regime_pars2}{a length \eqn{pd^2+d+d(d+1)/2} vector
\strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}.}
}
\value{
Returns "distance" between \code{regime_pars1} and \code{regime_pars2}. Values are scaled
  before calculating the "distance". Read the source code for more details.
}
\description{
\code{regime_distance} calculates "distantance" between two scaled regimes. This is used in
  the genetic algorithm.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
