% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{loglikelihood}
\alias{loglikelihood}
\title{Compute log-likelihood of GMVAR model using parameter vector}
\usage{
loglikelihood(data, p, M, params, conditional = TRUE,
  parametrization = c("intercept", "mean"), constraints = NULL,
  minval = NA)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a single time series. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{params}{a real valued vector specifying the parameter values.
\describe{
  \item{\strong{For regular models:}}{
    Should be size \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
    ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
    \itemize{
      \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
      \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
      \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
    }
  }
  \item{\strong{For constrained models:}}{
    Should be size \eqn{((M(d+d(d+1)/2+1)+q-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\psi}}
    \eqn{,\sigma_{1},...,\sigma_{M},\alpha_{1},...,\alpha_{M-1})}, where:
    \itemize{
      \item \strong{\eqn{\psi}} \eqn{(qx1)} satisfies (\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}
      \strong{\eqn{\phi}}\eqn{_{M}) =} \strong{\eqn{C \psi}}. Here \strong{\eqn{C}} is \eqn{(Mpd^2xq)}
      constraint matrix.
    }
  }
}
Above \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component and
\eqn{\alpha_{m}} is the mixing weight parameter.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks colums
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
The notations are in line with the cited article by \emph{Kalliovirta, Meitz and Saikkonen (2016)}.}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function
should be used. Default is \code{TRUE}.}

\item{parametrization}{\code{"mean"} or \code{"intercept"} determining whether the model is parametrized with regime means \eqn{\mu_{m}} or
intercept parameters \eqn{\phi_{m,0}}, m=1,...,M. Default is \code{"intercept"}.}

\item{constraints}{a size \eqn{(Mpd^2 x q)} constraint matrix \strong{\eqn{C}} specifying general linear constraints
to the autoregressive parameters. We consider constraints of form
(\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}\strong{\eqn{\phi}}\eqn{_{M}) = }\strong{\eqn{C \psi}},
where \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p}) (pd^2 x 1), m=1,...,M}
contains the coefficient matrices and \strong{\eqn{\psi}} \eqn{(q x 1)} contains the constrained parameters.
For example, to restrict the AR-parameters to be the same for all regimes, set \strong{\eqn{C}}=
[\code{I:...:I}]\strong{'} \eqn{(Mpd^2 x pd^2)} where \code{I = diag(p*d^2)}.
Ignore (or set to \code{NULL}) if linear constraints should \strong{not} be employed.}

\item{minval}{value that will be returned if the parameter vector does not lie in the parameter space
(excluding the identification condition).}
}
\value{
Returns log-likelihood if \code{params} is in the parameters space and \code{minval} if not.
}
\description{
\code{loglikelihood} computes log-likelihood of GMVAR model by using parameter vector
  instead of object of class 'gmvar'. Exists for convenience if one wants to for example
  plot profile log-likelihoods or employ other estimation algorithms than used in \code{fitGMVAR}.
  Use \code{minval} to control what happens when the parameter vector is outside the parameter space.
}
\details{
Takes use of the function \code{dmvn} from the package \code{mvnfast} to cut down computation time.
  Values extremely close to zero are handled with the package \code{Brobdingnag}.
}
\examples{
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
params222 <- c(-11.904, 154.684, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 11.633, 124.983, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
loglikelihood(data=data, p=2, M=2, params=params222, parametrization="mean")
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
           \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{calc_gradient}}
}
