% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncondMoments.R
\name{uncond_moments}
\alias{uncond_moments}
\title{Calculate the unconditional mean, variance, the first p autocovariances, and the first p autocorrelations
 of a GMVAR process}
\usage{
uncond_moments(gmvar)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}
}
\value{
Returns a list with three components:
  \describe{
    \item{\code{$uncond_mean}}{a length d vector containing the unconditional mean of the process.}
    \item{\code{$autocovs}}{an \eqn{(d x d x p+1)} array containing the lag 0,1,...,p autocovariances of
      the process. The subset \code{[, , j]} contains the lag \code{j-1} autocovariance matrix (lag zero for the variance).}
    \item{\code{$autocors}}{the autocovariance matrices scaled to autocorrelation matrices.}
  }
}
\description{
\code{uncond_moments} calculates the unconditional mean, variance, the first p autocovariances,
 and the first p autocorrelations of the given GMVAR process.
}
\details{
The unconditional moments are based on the stationary distribution of the process.
}
\examples{
# GMVAR(1,2), d=2 model:
params122 <- c(0.623, -0.129, 0.959, 0.089, -0.006, 1.006, 1.746,
 0.804, 5.804, 3.245, 7.913, 0.952, -0.037, -0.019, 0.943, 6.926,
 3.982, 12.135, 0.789)
mod122 <- GMVAR(p=1, M=2, d=2, params=params122)
uncond_moments(mod122)

# GMVAR(2,2), d=2 model with AR-parameters restricted to be
# the same for both regimes:
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
params222c <- c(1.031, 2.356, 1.786, 3.000, 1.250, 0.060, 0.036,
 1.335, -0.290, -0.083, -0.047, -0.356, 0.934, -0.152, 5.201, 5.883,
 3.560, 9.799, 0.368)
mod222c <- GMVAR(p=2, M=2, d=2, params=params222c, constraints=C_mat)
uncond_moments(mod222c)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
           \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
 }
}
\seealso{
Other moment functions: 
\code{\link{cond_moments}()},
\code{\link{get_regime_autocovs}()},
\code{\link{get_regime_means}()}
}
\concept{moment functions}
