% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{AR}
\alias{AR}
\title{Create an Autoregressive P [AR(P)] Process}
\usage{
AR(phi = NULL, sigma2 = 1)
}
\arguments{
\item{phi}{A \code{vector} with double values for the \eqn{\phi}{phi} of an AR(P) process.}

\item{sigma2}{A \code{double} value for the variance, \eqn{\sigma ^2}{sigma^2}, of a WN process.}
}
\value{
An S3 object with called ts.model with the following structure:
\itemize{
 \item{process.desc}{Used in summary: "AR-1","AR-2", ..., "AR-P", "SIGMA2"}
 \item{theta}{\eqn{\phi_1}{phi[[1]]}, \eqn{\phi_2}{phi[[2]]}, ..., \eqn{\phi_p}{phi[[p]]}, \eqn{\sigma^2}{sigma^2}}
 \item{plength}{Number of Parameters}
 \item{desc}{"AR"}
 \item{obj.desc}{Depth of Parameters e.g. list(p,1)}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Setups the necessary backend for the AR(P) process.
}
\examples{
AR(1) # Slower version of AR1()
AR(phi=.32, sigma=1.3) # Slower version of AR1()
AR(2) # Equivalent to ARMA(2,0).
}
\author{
JJB
}

