% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dwt_cpp}
\alias{dwt_cpp}
\title{Discrete Wavelet Transform}
\usage{
dwt_cpp(x, filter_name, nlevels, boundary)
}
\arguments{
\item{x}{A \code{vector} with dimensions \eqn{N\times 1}{N x 1}.}

\item{filter_name}{A \code{string} indicating the filter.}

\item{nlevels}{An \code{integer}, \eqn{J}, indicating the level of the decomposition.}

\item{boundary}{A \code{string} indicating the type of boundary method to use. Either \code{boundary="periodic"} or \code{"reflection"}.}
}
\value{
y A \code{field<vec>} that contains the wavelet coefficients for each decomposition level
}
\description{
Calculation of the coefficients for the discrete wavelet transformation.
}
\details{
Performs a level J decomposition of the time series using the pyramid algorithm
}
\examples{
set.seed(999)
x = rnorm(2^8)
dwt_cpp(x, "haar", 4, boundary="periodic")
}
\author{
JJB
}

