% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{gts}
\alias{gts}
\title{Create a GMWM TS Object based on data}
\usage{
gts(data, freq = 1, unit = NULL, name = "")
}
\arguments{
\item{data}{A one column \code{matrix}, \code{data.frame}, or a numeric \code{vector}.}

\item{freq}{A \code{numeric} that provides the rate of samples. Default value is 1.}

\item{unit}{A \code{string} that contains the unit expression of the frequency. Default value is \code{NULL}.}

\item{name}{A \code{string} that provides an identifier to the data. Default value is an empty string.}
}
\value{
A \code{gts} object with the structure:
\itemize{
  \item{x:} {A \code{matirx} that contains x-axis values used to plot}
  \item{data:} {A \code{matrix} that contains data for combined processes}
  \item{freq:} {Numeric representation of frequency}
  \item{unit:} {String representation of the unit}
  \item{name:} {Name of the dataset}
}
}
\description{
Setups a time series oriented object that works well with graphing and summary utilities
}
\examples{
m = data.frame(rnorm(5))
gts(m)

x = gen.gts(WN(sigma2=1), 50)$data
x = gts(x)
}
\author{
JJB, Wenchao
}

