% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ar1_to_wv}
\alias{ar1_to_wv}
\title{AR1 process to WV}
\usage{
ar1_to_wv(phi, sig2, tau)
}
\arguments{
\item{phi}{A \code{double} that is the phi term of the AR(1) process}

\item{sig2}{A \code{double} corresponding to variance of AR(1) process}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}
}
\value{
A \code{vec} containing the wavelet variance of the AR(1) process.
}
\description{
This function compute the WV (haar) of an AR(1) process
}
\examples{
x.sim = gen_ar1( N = 10000, phi = 0.9, sigma2 = 4 )
ntau = floor(log(length(x.sim),2))
tau = 2^(1:ntau)
wv.theo = ar1_to_wv(phi = 0.9, sig2 = 16, tau)
plot(tau, wv.theo, col = "red")
}

