% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_dr}
\alias{deriv_dr}
\title{Analytic D matrix for drift process}
\usage{
deriv_dr(omega, tau)
}
\arguments{
\item{omega}{A \code{double} that is the slope of the drift.}

\item{tau}{A \code{vec} that contains the scales to be processed (e.g. 2^(1:J))}
}
\value{
A \code{matrix} with the first column containing the partial derivative with respect to \eqn{\omega _0}{omega[0]}.
}
\description{
Analytic D matrix for drift process
}
\details{
The haar wavelet variance is given as \eqn{{\nu ^2}\left( \tau  \right) = \frac{{{\tau ^2}\omega _0^2}}{2}}{nu^2(tau) = tau^2 omega_0^2 / 2}.
Taking the derivative with respect to \eqn{\omega _0^2}{omega_0^2} yields: \eqn{\frac{\partial }{{\partial {\omega _0}}}{\nu ^2}\left( \tau  \right) = {\tau ^2}{\omega _0}}{tau^2 * omega_0}
}
\examples{
deriv_dr(5.3, 2^(1:5))
}
\author{
JJB
}

