% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNoise.R
\name{fitNoise}
\alias{fitNoise}
\title{Find The Threshold Noise Level}
\usage{
fitNoise(dof, pct = 0.95, ndecimals = 2, fitmetric = R2, dist = rnorm,
  trend = NULL, ...)
}
\arguments{
\item{dof}{an integer}

\item{pct}{a real number between 0 and 1}

\item{ndecimals}{an integer}

\item{fitmetric}{a character string naming a standard fit metric ("R2", "rmse", or "user")}

\item{dist}{a random number distribution function}

\item{trend}{a character string "Increasing", "Decreasing", "Flat", "Uncertain" which describes the general slope of the fitmetric function.}

\item{...}{any argument that functions within this routine might use}
}
\value{
a real number
}
\description{
Finds the threshold noise level for a certain fit metric
}
\examples{
fitNoise(7)
fitNoise(4, fitmetric=rmse)

}

