% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConstNoise.R
\name{plotConstNoise}
\alias{plotConstNoise}
\title{Plot Measured Value with Constant Noise}
\usage{
plotConstNoise(measured_value, dof, doflist = c(2:30), pct = 0.95,
  order = 4, add_mvp = F, fitmetric = R2, ...)
}
\arguments{
\item{measured_value}{a real number within the range of fitmetric}

\item{dof}{an integer, degrees of freedom}

\item{doflist}{a vector of integers identifying the range of degrees of freedom to plot over}

\item{pct}{a real number between 0 and 1, minimum acceptable level of noise}

\item{order}{a real number}

\item{add_mvp}{a logical value indicating whether to include or not the fitEquive placed at each dof.}

\item{fitmetric}{a character string naming a standard fit metric (R2, rmse, or user)}

\item{...}{any argument that functions within this routine might use}
}
\value{
ggplot object
}
\description{
Plots the Fit Equivalent
}
\examples{
plotConstNoise(0.8, 5, doflist=c(2:10),order=3)
plotConstNoise(0.1, 5, doflist=c(2:10),order=3,fitmetric=rmse)

}

