% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_data.R
\name{update-method}
\alias{update-method}
\alias{as.data.frame.nodes.goldfish}
\alias{as.matrix.network.goldfish}
\title{Methods to update a nodes or network object}
\usage{
\method{as.data.frame}{nodes.goldfish}(x, ..., time = -Inf, startTime = -Inf, envir = new.env())

\method{as.matrix}{network.goldfish}(x, ..., time = -Inf, startTime = -Inf)
}
\arguments{
\item{x}{an object of class \code{nodes.goldfish} for \code{as.data.frame()}
method or \code{network.goldfish} for \code{as.matrix()} method.}

\item{...}{Not further arguments are required.}

\item{time}{a numeric value or a calendar date value (see \code{\link[=as.Date]{as.Date()}})
to update the state of the object \code{x} until this time value
(event time < time).}

\item{startTime}{a numeric \code{as.Date} format value; prior events are
disregarded.}

\item{envir}{an \code{environment} where the nodes and linked events
objects are available.}
}
\value{
The respective object updated accordingly to the events link to it.
For \code{nodes.goldfish} object the attributes are updated according to the
events linked to them.
For \code{network.goldfish} object the network ties are updated according to the
events linked to it.
}
\description{
Methods to create a data frame from an object of class \code{nodes.goldfish}
(see \code{\link[=defineNodes]{defineNodes()}}) or a matrix from an object of class
\code{network.goldfish} (see \code{\link[=defineNetwork]{defineNetwork()}}) with the attributes
or the network ties updated according with the events linked to the object
using the \code{\link[=linkEvents]{linkEvents()}}) function.
}
\examples{
\donttest{
data("Fisheries_Treaties_6070")
states <- defineNodes(states)
states <- linkEvents(states, sovchanges, attribute = "present")
states <- linkEvents(states, regchanges, attribute = "regime")
states <- linkEvents(states, gdpchanges, attribute = "gdp")

bilatnet <- defineNetwork(bilatnet, nodes = states, directed = FALSE)
bilatnet <- linkEvents(bilatnet, bilatchanges, nodes = states)

updateStates <- as.data.frame(
  states,
  time = as.numeric(as.POSIXct("1965-12-31"))
)


updateNet <- as.matrix(bilatnet, time = as.numeric(as.POSIXct("1965-12-31")))
}

}
\seealso{
\code{\link[=defineNetwork]{defineNetwork()}}, \code{\link[=defineNodes]{defineNodes()}}, \code{\link[=linkEvents]{linkEvents()}}
}
