% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-run.R
\name{cr_deploy_run}
\alias{cr_deploy_run}
\alias{cr_deploy_html}
\alias{cr_deploy_plumber}
\title{Deploy to Cloud Run}
\usage{
cr_deploy_run(
  local,
  remote = basename(local),
  dockerfile = NULL,
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L
)

cr_deploy_html(
  html_folder,
  remote = basename(html_folder),
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L
)

cr_deploy_plumber(
  api,
  remote = basename(api),
  dockerfile = NULL,
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L
)
}
\arguments{
\item{local}{A folder containing the scripts and Dockerfile to deploy to Cloud Run}

\item{remote}{The folder on Google Cloud Storage, and the name of the service on Cloud Run}

\item{dockerfile}{An optional Dockerfile built to support the script.  Not needed if 'Dockerfile' exists in folder.  If supplied will be copied into deployment folder and called "Dockerfile"}

\item{image_name}{The gcr.io image name that will be deployed and/or built}

\item{tag}{The tag to attached to the pushed image - can use \code{Build} macros}

\item{region}{The Cloud Run endpoint set by CR_REGION env arg}

\item{bucket}{The Cloud Storage bucket that will hold the code}

\item{projectId}{The projectId where it all gets deployed to}

\item{launch_browser}{Whether to launch the logs URL in a browser once deployed}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{html_folder}{the folder containing all the html}

\item{api}{A folder containing the R script using plumber called api.R and all its dependencies}
}
\description{
Deploy R api plumber scripts, HTML files or other images create the Docker image, add the build to Cloud Build and deploy to Cloud Run
}
\details{
These deploy containers to Cloud Run, a scale 0-to-millions container-as-a-service on Google Cloud Platform.




}
\section{cr_deploy_html}{

Deploy html files to a nginx server on Cloud Run.

Supply the html folder to host it on Cloud Run.  Builds the dockerfile with the html within it, then deploys to Cloud Run

Will add a \code{default.template} file to the html folder that holds the nginx configuration
}

\section{cr_deploy_plumber}{


The entrypoint for CloudRun will be via a plumber script called api.R - this should be included in your local folder to deploy.
From that api.R you can source or call other resources in the same folder, using relative paths.

The function will create a local folder called "deploy" and a tar.gz of that folder which is what is being uploaded to Google Cloud Storage
}

\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")
cr_deploy_run(system.file("example/", package = "googleCloudRunner"))

}

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")

cr_deploy_html("my_folder")

}

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")

cr_deploy_plumber(system.file("example/", package = "googleCloudRunner"))

}
}
\seealso{
Other Deployment functions: 
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_git_html}()},
\code{\link{cr_deploy_github_docker}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
