% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers_events.R
\name{cr_buildtrigger_pubsub}
\alias{cr_buildtrigger_pubsub}
\title{Create a buildtrigger pub/sub object}
\usage{
cr_buildtrigger_pubsub(
  topic,
  serviceAccountEmail = NULL,
  projectId = cr_project_get()
)
}
\arguments{
\item{topic}{The name of the Cloud Pub/Sub topic or a Topic object from \link[googlePubsubR]{topics_get}}

\item{serviceAccountEmail}{Service account that will make the push request.}

\item{projectId}{The GCP project the topic is created within}
}
\description{
Create a trigger from a Pub/Sub topic
}
\details{
When using a PubSub trigger, you can use data within your PubSub message in substitution variables within the build.  The data from pubsub is available in the variable value: \code{$(body.message.data.x)} when x is a field in the pubsub message.
}
\examples{

# create build object
cloudbuild <- system.file("cloudbuild/cloudbuild_substitutions.yml",
  package = "googleCloudRunner"
)
the_build <- cr_build_make(cloudbuild)

# this build includes substitution variables that read from pubsub message var1
the_build

# using googlePubSubR to create pub/sub topic if needed
\dontrun{
library(googlePubsubR)
pubsub_auth()
topics_create("test-topic")
}

# create build trigger that will work from pub/subscription
pubsub_trigger <- cr_buildtrigger_pubsub("test-topic")
pubsub_trigger
\dontrun{
cr_buildtrigger(the_build, name = "pubsub-triggered-subs", trigger = pubsub_trigger)
}

# make base64 encoded json for pubsub
library(jsonlite)
library(googlePubsubR)

# the message with the var1 that will be passed into the Cloud Build via substitution
message <- toJSON(list(var1 = "hello mum"))

# turning into JSON and encoding
send_me <- msg_encode(message)
\dontrun{
# send a PubSub message with the encoded data message
topics_publish(PubsubMessage(send_me), "test-topic")

# did it work? After a while should see logs if it did
cr_buildtrigger_logs("pubsub-triggered-subs")
}

}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_copy}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger_webhook}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
