% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vms.R
\name{gce_vm}
\alias{gce_vm}
\title{Create or fetch a virtual machine}
\usage{
gce_vm(name, ..., project = gce_get_global_project(),
  zone = gce_get_global_zone())
}
\arguments{
\item{name}{The name of the instance}

\item{...}{Other arguments passed to create an instance if it doesn't exist}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}
}
\value{
A \code{gce_instance} object
}
\description{
Pass in the instance name to fetch its object, or create the instance.
}
\details{
Will get or create the instance as specified.  Will wait for instance to be created if necessary.

Make sure the instance is big enough to handle what you need, for instance the default "f1-micro" will hang the instance 
when trying to install certain R libraries.
}
\section{Creation logic}{


You need these parameters defined to call the right function for creation.  Check the function definitions for more details. 

If you specify the argument \code{template} it will call \link{gce_vm_template}

If you specify one of \code{file} or \code{cloud_init} it will call \link{gce_vm_container}

Otherwise it will call \link{gce_vm_create}
}

