% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{Topic}
\alias{Topic}
\title{Builds a Topic Object}
\usage{
Topic(
  labels = NULL,
  name = NULL,
  kms_key_name = NULL,
  satisfies_pzs = NULL,
  message_storage_policy = NULL,
  schema_settings = NULL,
  message_retention_duration = NULL
)
}
\arguments{
\item{labels}{\code{list} Key-value pairs for topic labels}

\item{name}{\code{character} Name of the topic}

\item{kms_key_name}{\code{character} The resource name of the Cloud KMS CryptoKey to be used
to protect access to messages published on this topic}

\item{satisfies_pzs}{\code{logical} Reserved for future use}

\item{message_storage_policy}{\code{MessageStoragePolicy} Policy constraining the set of Google Cloud
Platform regions where messages published to the topic may be stored}

\item{schema_settings}{\code{SchemaSettings} Settings for validating messages published against
a schema}

\item{message_retention_duration}{\code{character} Indicates the minimum duration to retain a message
after it is published to the topic}
}
\value{
\code{Topic} object
}
\description{
Builds a Topic Object
}
\seealso{
Other Object functions: 
\code{\link{DeadLetterPolicy}()},
\code{\link{DlqPolicy}()},
\code{\link{ExpirationPolicy}()},
\code{\link{MessageStoragePolicy}()},
\code{\link{PubsubMessage}()},
\code{\link{PushConfig}()},
\code{\link{RetryPolicy}()},
\code{\link{SchemaSettings}()},
\code{\link{Schema}()},
\code{\link{Snapshot}()},
\code{\link{Subscription}()}
}
\concept{Object functions}
