% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{gtm_tags_get}
\alias{gtm_tags_get}
\title{Get one tag in a workspace}
\usage{
gtm_tags_get(account_id, container_id, workspace_id, tag_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{tag_id}{Tag Id}
}
\description{
This will return a list with the settings of a single tag.
If you want to get the information for all tags, use \code{gtm_tags_list}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
tagId = 100

tag <- gtm_tags_get(accountId, containerId, workspaceId, tagId)

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/tags/get}

Other tag functions: 
\code{\link{gtm_tags_create}()},
\code{\link{gtm_tags_delete}()},
\code{\link{gtm_tags_list}()},
\code{\link{gtm_tags_revert}()},
\code{\link{gtm_tags_update}()}
}
\concept{tag functions}
