% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{gtm_tags_delete}
\alias{gtm_tags_delete}
\title{Delete a tag}
\usage{
gtm_tags_delete(
  account_id,
  container_id,
  workspace_id,
  tag_id,
  force = c("TRUE", "FALSE")
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{tag_id}{Tag Id}

\item{force}{Force deletion without user input}
}
\description{
This deletes a tag in a GTM workspace
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
tagId <- 100

gtm_tags_delete(accountId, containerId, workspaceId, tagId)

# This will delete tag \%s. Are you sure you want to continue?

#  1: Yes
#  2: No

# Selection: 1

# Tag 100 has been deleted.

tagId = 101

gtm_tags_delete(accountId, containerId, workspaceId, tagId, "TRUE")

# Tag 101 has been deleted.

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/tags/delete}

Other tag functions: 
\code{\link{gtm_tags_create}()},
\code{\link{gtm_tags_get}()},
\code{\link{gtm_tags_list}()},
\code{\link{gtm_tags_revert}()},
\code{\link{gtm_tags_update}()}
}
\concept{tag functions}
