% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permissions.R
\name{gs_perm_ls}
\alias{gs_perm_ls}
\title{List permissions for a spreadsheet}
\usage{
gs_perm_ls(ss, filter = NULL)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{filter}{character, optional; the email or unique ID of a user that,
  if provided, will be used to filter the results}
}
\value{
a tbl_df, one row per permission
}
\description{
This function lists all the permissions for a spreadsheet, as reported via
the
\href{https://developers.google.com/drive/v2/reference/permissions}{permissions
feed} of the Google Drive API. A simplified view of this information is
available in the browser in the sharing dialog of a Google Sheet.
}
\details{
The first row corresponds to the owner of the spreadsheet. Permissions for
other users or groups, if such exist, follow in additional rows.

A permission for a sheet includes the following information: the name for
this permission, the email of the user or group the permission refers to, the
primary role for the user, any additional roles they have, the type of user
they are, the (unique) ID of the user this permission refers to, a link back
to this permission, and the ETag of the permission.
}
\examples{
\dontrun{
foo <- gs_new("foo")
gs_perm_ls(foo)
gs_delete(foo)
}
}
\keyword{internal}

