% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_webapp.R
\name{gs_webapp_auth_url}
\alias{gs_webapp_auth_url}
\title{Build URL for authentication}
\usage{
gs_webapp_auth_url(client_id = getOption("googlesheets.webapp.client_id"),
  redirect_uri = getOption("googlesheets.webapp.redirect_uri"),
  access_type = "online", approval_prompt = "auto")
}
\arguments{
\item{client_id}{client id obtained from Google Developers Console}

\item{redirect_uri}{where the response is sent, should be one of the
redirect_uri values listed for the project in Google's Developer Console,
must match exactly as listed including any trailing '/'}

\item{access_type}{either "online" (no refresh token) or "offline" (refresh
token), determines whether a refresh token is returned in the response}

\item{approval_prompt}{either "force" or "auto", determines whether the user
  is reprompted for consent, If set to "auto", then the user only has to see
  the consent page once for the first time through the authorization
  sequence. If set to "force" then user will have to grant consent everytime
  even if they have previously done so.}
}
\description{
Build the Google URL that \code{googlesheets} needs to direct users to in
order to authenticate in a Web Server Application. This function is designed
for use in Shiny apps. In contrast, the default authorization sequence in
\code{googlesheets} is appropriate for a user working directly with R on a
local computer, where the default handshakes between the local computer and
Google work just fine. The first step in the Shiny-based workflow is to form
the Google URL where the user can authenticate him or herself with Google.
After success, the response, in the form of an authorization code, is sent to
the \code{redirect_uri} (see below) which \code{\link{gs_webapp_get_token}}
uses to exchange for an access token. This token is then stored in the usual
manner for this package and used for subsequent API requests.
}
\details{
That was the good news. The bad news is you'll need to use the
\href{https://console.developers.google.com}{Google Developers Console} to
\strong{obtain your own client ID and secret and declare the
\code{redirect_uri} specific to your project}. Inform \code{googlesheets} of
this information by providing as function arguments or by defining these
options. For example, you can put lines like this into a Project-specific
\code{.Rprofile} file:

options("googlesheets.webapp.client_id" = MY_CLIENT_ID)
options("googlesheets.webapp.client_secret" = MY_CLIENT_SECRET)
options("googlesheets.webapp.redirect_uri" = MY_REDIRECT_URI)

Based on Google Developers' guide to
\href{https://developers.google.com/identity/protocols/OAuth2WebServer}{Using
OAuth2.0 for Web Server Applications}.
}
\seealso{
\code{\link{gs_webapp_get_token}}
}

