% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_read_cellfeed.R
\name{gs_read_cellfeed}
\alias{gs_read_cellfeed}
\title{Read data from cells}
\usage{
gs_read_cellfeed(ss, ws = 1, range = NULL, ..., return_empty = FALSE,
  return_links = FALSE, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{range}{a cell range, as described in \code{\link{cell-specification}}}

\item{...}{\strong{Optional} arguments to control data download, parsing, and
  reshaping; for most purposes, the defaults should be fine. Anything that is
  not listed here will be silently ignored.
\describe{
  \item{\code{progress}}{Logical. Whether to display download progress if in
  an interactive session.}
  \item{\code{col_types}}{Seize control of type conversion for variables.
  Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}. Follow those links
  or read the \code{vignette("column-types")} for details.}
  \item{\code{locale, trim_ws, na}}{Specify locale, the fate of leading or
  trailing whitespace, or a character vector of strings that should become
  missing values. Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}.}
  \item{\code{comment, skip, n_max}}{Specify a string used to identify
  comments, request to skip lines before reading data, or specify the
  maximum number of data rows to read.}
  \item{\code{col_names}}{Either \code{TRUE}, \code{FALSE} or a character
  vector of column names. If \code{TRUE}, the first row of the data rectangle
  will be used for names. If \code{FALSE}, column names will be X1, X2, etc.
  If a character vector, it will be used as column names. If the sheet
  contains column names and you just don't like them, specify \code{skip = 1}
  so they don't show up in your data.}
  \item{\code{check.names}}{Logical. Whether to run column names through
  \code{\link{make.names}} with \code{unique = TRUE}, just like
  \code{\link{read.table}} does. By default, \code{googlesheets} implements
  the \code{readr} data ingest philosophy, which leaves column names "as is",
  with one exception: data frames returned by \code{googlesheets} will have
  a name for each variable, even if we have to create one.}
}}

\item{return_empty}{logical; indicates whether to return empty cells}

\item{return_links}{logical; indicates whether to return the edit and self
links (used internally in cell editing workflow)}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{data.frame} or, if \code{dplyr} is loaded, a
  \code{\link[dplyr]{tbl_df}}
}
\description{
This function consumes data via the "cell feed", which, as the name suggests,
retrieves data cell by cell. Note that the output is a data frame with
\strong{one row per cell}. Consult the Google Sheets API documentation for
more details about
\href{https://developers.google.com/google-apps/spreadsheets/data#work_with_cell-based_feeds}{the
cell feed}.
}
\details{
Use the \code{range} argument to specify which cells you want to read. See
the examples and the help file for the \link[=cell-specification]{cell
specification functions} for various ways to limit consumption to, e.g., a
rectangle or certain columns. If \code{range} is specified, the associated
cell limits will be checked for internal consistency and compliance with the
known extent of the worksheet. If no limits are provided, all cells will be
returned but consider that \code{\link{gs_read_csv}} and
\code{\link{gs_read_listfeed}} are much faster ways to consume all the data
from a rectangular worksheet.

Empty cells, even if "embedded" in a rectangular region of populated cells,
are not normally returned by the cell feed. This function won't return them
either when \code{return_empty = FALSE} (default), but will if you set
\code{return_empty = TRUE}.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
col_4_and_above <-
  gs_read_cellfeed(gap_ss, ws = "Asia", range = cell_limits(c(NA, 4)))
col_4_and_above
gs_reshape_cellfeed(col_4_and_above)

gs_read_cellfeed(gap_ss, range = "A2:F3")
}
}
\seealso{
\code{\link{gs_reshape_cellfeed}} or
  \code{\link{gs_simplify_cellfeed}} to perform reshaping or simplification,
  respectively; \code{\link{gs_read}} is a pre-made wrapper that combines
  \code{gs_read_cellfeed} and \code{\link{gs_reshape_cellfeed}}

Other data consumption functions: \code{\link{gs_read_csv}},
  \code{\link{gs_read_listfeed}}, \code{\link{gs_read}},
  \code{\link{gs_reshape_cellfeed}},
  \code{\link{gs_simplify_cellfeed}}
}
\concept{data consumption functions}
