% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster_from_polygon.R
\name{gt_make_raster_from_polygon}
\alias{gt_make_raster_from_polygon}
\title{Make Google Traffic Raster Based on Polygon}
\usage{
gt_make_raster_from_polygon(
  polygon,
  zoom,
  google_key,
  height_width_max = 2000,
  height = NULL,
  width = NULL,
  traffic_color_dist_thresh = 4.6,
  traffic_color_dist_metric = "CIEDE2000",
  webshot_zoom = 1,
  webshot_delay = NULL,
  reduce_hw = 10,
  return_list_of_rasters = FALSE,
  mask_to_polygon = TRUE,
  print_progress = TRUE
)
}
\arguments{
\item{polygon}{Polygon (\code{sf} object or \code{SpatialPolygonsDataframe}) in WGS84 CRS}

\item{zoom}{Zoom level; integer from 5 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here} and \href{https://developers.google.com/maps/documentation/javascript/overview#zoom-levels}{here}.}

\item{google_key}{Google API key, where the \href{https://developers.google.com/maps/documentation/javascript/overview}{Maps JavaScript API} is enabled. To create a Google API key, follow \href{https://developers.google.com/maps/get-started#create-project}{these instructions}.}

\item{height_width_max}{Maximum pixel height and width to check using for each API query (pixel length depends on zoom). If the same number of API queries can be made with a smaller height/width, the function will use a smaller height/width. If \code{height} and \code{width} are specified, that height and width will be used and \code{height_width_max} will be ignored. (Default: \code{2000})}

\item{height}{Height, in pixels, for each API query (pixel length depends on zoom). Enter a \code{height} to manually specify the height; otherwise, a height of \code{height_width_max} or smaller will be used.}

\item{width}{Pixel, in pixels, for each API query (pixel length depends on zoom). Enter a \code{width} to manually specify the width; otherwise, a width of \code{height_width_max} or smaller will be used.}

\item{traffic_color_dist_thresh}{Google traffic relies on four main base colors: \verb{#63D668} for no traffic, \verb{#FF974D} for medium traffic, \verb{#F23C32} for high traffic, and \verb{#811F1F} for heavy traffic. Slight variations of these colors can also represent traffic. By default, the base colors and all colors within a 4.6 color distance of each base color are used to define traffic; by default, the \code{CIEDE2000} metric is used to determine color distance. A value of 2.3 is one threshold used to define a "just noticeable distance" (JND) between colors (by default, 2 X JND is used). This parameter changes the color distance from the base colors used to define colors as traffic. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{traffic_color_dist_metric}{See above; this parameter changes the metric used to calculate distances between colors. By default, \code{CIEDE2000} is used; \code{CIE76} and \code{CIE94} can also be used. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{webshot_zoom}{How many pixels should be created relative to height and width values. If \code{height} and \code{width} are set to \code{100} and \code{webshot_zoom} is set to \code{2}, the resulting raster will have dimensions of about \verb{200x200} (default: \code{1}).}

\item{webshot_delay}{How long to wait for Google traffic layer to render (in seconds). Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{reduce_hw}{Number of pixels to reduce height/width by. Doing so creates some overlap between grids to ensure there is not blank space between tiles. (Default: \code{10}).}

\item{return_list_of_rasters}{Whether to return a list of raster tiles instead of mosaicing together. (Default: \code{FALSE}).}

\item{mask_to_polygon}{Whether to mask raster to \code{polygon}. (Default: \code{TRUE}).}

\item{print_progress}{Show progress for which grid / API query has been processed. (Default: \code{TRUE}).}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster of \href{https://developers.google.com/maps/documentation/javascript/trafficlayer}{Google traffic data}, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
## Grab polygon of Manhattan
us_sp <- raster::getData('GADM', country='USA', level=2)
ny_sp <- us_sp[us_sp$NAME_2 \%in\% "New York",]

## Make raster
r <- gt_make_raster_from_polygon(polygon    = ny_sp,
                                 height     = 2000,
                                 width      = 2000,
                                 zoom       = 16,
                                 google_key = "GOOGLE-KEY-HERE")
} 

}
\references{
Markus Hilpert, Jenni A. Shearston, Jemaleddin Cole, Steven N. Chillrud, and Micaela E. Martinez. \href{https://arxiv.org/abs/2105.12235}{Acquisition and analysis of crowd-sourced traffic data}. CoRR, abs/2105.12235, 2021.

Pavel Pokorny. \href{https://ieeexplore.ieee.org/abstract/document/8326831}{Determining traffic levels in cities using google maps}. In 2017 Fourth International Conference on Mathematics and Computers in Sciences and in Industry (MCSI), pages 144–147, 2017.
}
