% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map.R
\name{google_map}
\alias{google_map}
\alias{googleway}
\title{Google map}
\usage{
google_map(
  data = NULL,
  key = get_api_key("map"),
  location = NULL,
  zoom = NULL,
  width = NULL,
  height = NULL,
  padding = 0,
  styles = NULL,
  search_box = FALSE,
  update_map_view = TRUE,
  zoom_control = TRUE,
  map_type = c("roadmap", "satellite", "hybrid", "terrain"),
  map_type_control = TRUE,
  scale_control = FALSE,
  street_view_control = TRUE,
  rotate_control = TRUE,
  fullscreen_control = TRUE,
  libraries = NULL,
  split_view = NULL,
  split_view_options = NULL,
  geolocation = FALSE,
  event_return_type = c("list", "json")
)
}
\arguments{
\item{data}{data to be used on the map. Either a data.frame, or an \code{sf} object. See details}

\item{key}{A valid Google Maps API key.}

\item{location}{\code{numeric} vector of latitude/longitude (in that order)
coordinates for the initial starting position of the map.
The map will automatically set the location and zoom if data is added through one
of the various \code{add_} functions. If null, the map will default to Melbourne, Australia.}

\item{zoom}{\code{integer} representing the zoom level of the map (0 is fully zoomed out)}

\item{width}{the width of the map}

\item{height}{the height of the map}

\item{padding}{the padding of the map}

\item{styles}{JSON string representation of a valid Google Maps styles Array.
See the Google documentation for details \url{https://developers.google.com/maps/documentation/cloud-customization/cloud-based-map-styling}}

\item{search_box}{\code{boolean} indicating if a search box should be placed on the map}

\item{update_map_view}{logical indicating if the map should center on the searched location}

\item{zoom_control}{logical indicating if the zoom control should be displayed}

\item{map_type}{defines the type of map to display. One of 'roadmap', 'satellite', 'terrain' or 'hybrid'}

\item{map_type_control}{logical indicating if the map type control should be displayed}

\item{scale_control}{logical indicating if the scale control should be displayed}

\item{street_view_control}{logical indicating if the street view control should be displayed}

\item{rotate_control}{logical indicating if the rotate control should be displayed}

\item{fullscreen_control}{logical indicating if the full screen control should be displayed}

\item{libraries}{vector containing the libraries you want to load. See details}

\item{split_view}{string giving the name of a UI output element in which to place
a streetview representation of the map. Will only work in an interactive environment (shiny).}

\item{split_view_options}{list of options to pass to the split street view.
valid list elements are \code{heading} and \code{pitch}
see \link{google_mapOutput}}

\item{geolocation}{logical indicating if you want geolocation enabled}

\item{event_return_type}{the type of data to return to R from an interactive environment (shiny),
either an R list, or raw json string.}
}
\description{
Generates a google map object
}
\details{
In order to use Google Maps you need a valid Google Maps Web JavaScript API key.
See the Google Maps API documentation \url{https://mapsplatform.google.com/}

The data argument is only needed if you call other functions to add layers to the map,
such as \code{add_markers()} or \code{add_polylines}. However, the data argument
can also be passed into those functions as well.

The data can either be a data.frame containing longitude and latitude columns
or an encoded polyline for plotting polylines and polygons, or an \code{sf} object.

The supported \code{sf} object types are

\itemize{
  \item{POINT}
  \item{MULTIPOINT}
  \item{LINESTRING}
  \item{MULTILINESTRING}
  \item{POLYGON}
  \item{MULTIPOLYGON}
  \item{GEOMETRY}
}


The libraries argument can be used to turn-off certain libraries from being called.
By default the map will load
\itemize{
 \item{visualization - includes the HeatmapLayer for visualising heatmaps
 \url{https://developers.google.com/maps/documentation/javascript/visualization}}
 \item{geometry - utility functions for computation of geometric data on the surface of
 the earth, including plotting encoded polylines.
 \url{https://developers.google.com/maps/documentation/javascript/geometry}}
 \item{places - enables searching for places.
 \url{https://developers.google.com/maps/documentation/javascript/places}}
 \item{drawing - provides a graphical interface for users to draw polygons, rectangles,
 circles and markers on the map. \url{https://developers.google.com/maps/documentation/javascript/drawinglayer}}
}
}
\examples{
\dontrun{

map_key <- "your_api_key"

google_map(key = map_key, data = tram_stops) \%>\%
 add_markers() \%>\%
 add_traffic()

## style map using 'cobalt simplified' style
style <- '[{"featureType":"all","elementType":"all","stylers":[{"invert_lightness":true},
{"saturation":10},{"lightness":30},{"gamma":0.5},{"hue":"#435158"}]},
{"featureType":"road.arterial","elementType":"all","stylers":[{"visibility":"simplified"}]},
{"featureType":"transit.station","elementType":"labels.text","stylers":[{"visibility":"off"}]}]'

google_map(key = map_key, styles = style)

}

}
\seealso{
\link{google_mapOutput}
}
