% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\alias{reliability.default}
\alias{reliability.PlackettLuce}
\alias{reliability.pltree}
\title{Probability of outperforming a check}
\usage{
reliability(x, ...)

\method{reliability}{default}(x, y = NULL, ...)

\method{reliability}{PlackettLuce}(x, ref, ...)

\method{reliability}{pltree}(x, ref, ...)
}
\arguments{
\item{x}{a numeric vector, or an object
of class \code{PlackettLuce} or \code{pltree}}

\item{...}{additional arguments passed to methods}

\item{y}{numeric, the reference value}

\item{ref}{a character or integer for indexing the
element containing reference values in \var{x}}
}
\value{
the reliability based on the worth parameters
}
\description{
Measures the precision of estimated values, and
 the potential response to selection on those 
 estimated values compared to a check
}
\examples{
# Case 1. vector example

x = c(9.5, 12, 12.3, 17)

y = 11.2

reliability(x, y)

# Case 2. PlackettLuce model

library("PlackettLuce") 

R = matrix(c(1, 2, 4, 3,
              4, 1, 2, 3,
              2, 3, 1, 4,
              4, 2, 3, 1,
              2, 1, 4, 3,
              1, 4, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) = c("apple", "banana", "orange", "pear")

mod = PlackettLuce(R)

reliability(mod, ref = "orange")

\donttest{
# Case 3. PlackettLuce tree

data("beans", package = "PlackettLuce")

G = rank_tricot(data = beans,
                 items = c(1:3),
                 input = c(4:5),
                 group = TRUE,
                 additional.rank = beans[c(6:8)])

pld = cbind(G, beans[,c("maxTN", "season", "lon")])

tree = pltree(G ~ maxTN + season + lon, data = pld)

reliability(tree, ref = "Local")

}
}
\references{
Eskridge and Mumm (1992). Theoret. Appl. Genetics 84, 494–500 \doi{10.1007/BF00229512}.
}
\author{
Kauê de Sousa, David Brown, Jacob van Etten
}
