% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datdti.R
\docType{data}
\name{datdti}
\alias{datdti}
\title{Data of estimating drought tolerance indices without replication}
\format{
A dataframe of eight variables.
\describe{
 \item{ENV}{two environment}
 \item{GEN}{fifteen genotypes}
 \item{CL}{trait cob length}
 \item{CG}{trait cob girth}
 \item{NKR}{trait number of kernel rows}
 \item{NKPR}{trait number of kernels per row}
 \item{HSW}{trait hundred seed weight}
 \item{GY}{trait grain yield}
}
}
\usage{
data(datdti)
}
\description{
The sample data containing 15 genotypes evaluated under non-stress and stress conditions without replications
}
\examples{
result = dti(datdti, environment = ENV, genotype = GEN, datdti[,3:8], ns = 'NS-DWR', st = 'ST-DWR')
}
\seealso{
\code{\link{datrdti}}
   ,\code{\link{alphaltc}}
   ,\code{\link{rcbdltc}}
}
\keyword{datasets}
